/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.casting_basin;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.recipes.CastingRecipe;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CastingBasinBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    int flowTimer = 0;
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this, 1, false);
    public FluidTank tank = new SmartFluidTank(144, this::onFluidChanged);
    public LazyOptional<IFluidHandler> fluidCapability;
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public CastingRecipe recipe = null;
    public int timer = 0;
    private static final Object castingRecipeKey = new Object();
    LerpedFloat fluidLevel = LerpedFloat.linear();

    public CastingBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tank);
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap);
    }

    public void tick() {
        super.tick();
        if (this.tank.getSpace() == 0) {
            if (this.recipe == null) {
                this.findRecipe();
            }
            if (this.recipe != null) {
                if (this.recipe.getIngrenient().test(this.tank.getFluid())) {
                    if (this.timer >= this.recipe.getProcessingDuration()) {
                        this.tank.setFluid(FluidStack.EMPTY);
                        this.inventory.setStackInSlot(0, ((ProcessingOutput)this.recipe.getRollableResults().get(0)).rollOutput());
                        this.recipe = null;
                        this.timer = 0;
                    } else {
                        ++this.timer;
                    }
                } else {
                    this.findRecipe();
                }
            } else {
                this.timer = 0;
            }
        }
        if (this.f_58857_.f_46443_) {
            if (this.flowTimer > 0) {
                --this.flowTimer;
            }
            this.fluidLevel.chase((double)this.tank.getFluidAmount(), (double)0.3f, LerpedFloat.Chaser.EXP);
            this.fluidLevel.tickChaser();
        }
    }

    public void findRecipe() {
        this.recipe = null;
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, r -> r instanceof CastingRecipe);
        for (Recipe recipe1 : list) {
            CastingRecipe testedRecipe = (CastingRecipe)recipe1;
            if (!testedRecipe.getIngrenient().test(this.tank.getFluid()) || !this.inventory.m_7983_()) continue;
            this.recipe = testedRecipe;
            return;
        }
    }

    protected Object getRecipeCacheKey() {
        return castingRecipeKey;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void onFluidChanged(FluidStack stack) {
        this.flowTimer = 10;
        this.sendData();
        this.m_6596_();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        compound.m_128405_("Timer", this.timer);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.tank.readFromNBT(compound.m_128469_("Tank"));
        this.timer = compound.m_128451_("Timer");
    }
}

