/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt.processor;

import com.mojang.serialization.DynamicOps;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NBTProcessor
public class ArmorTrimProcessor
implements INBTProcessor {
    @Override
    public String getName() {
        return "ArmorTrimProcessor";
    }

    @Override
    public String getDescription() {
        return "Calculates EMC value of trimmed armor.";
    }

    @Override
    public boolean hasPersistentNBT() {
        return true;
    }

    @Override
    public long recalculateEMC(@NotNull ItemInfo info, long currentEMC) throws ArithmeticException {
        CompoundTag tag;
        if (info.is((TagKey<Item>)ItemTags.f_265942_) && (tag = info.getNBT()) != null && tag.m_128425_("Trim", 10)) {
            RegistryAccess.Frozen registryAccess;
            CompoundTag compoundtag = tag.m_128469_("Trim");
            if (FMLEnvironment.dist.isClient()) {
                registryAccess = Minecraft.m_91087_().f_91073_ == null ? null : Minecraft.m_91087_().f_91073_.m_9598_();
            } else {
                RegistryAccess.Frozen frozen = registryAccess = ServerLifecycleHooks.getCurrentServer() == null ? null : ServerLifecycleHooks.getCurrentServer().m_206579_();
            }
            if (registryAccess == null) {
                return 0L;
            }
            ArmorTrim armortrim = ArmorTrim.f_265985_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess), (Object)compoundtag).result().orElse(null);
            if (armortrim != null) {
                Item material = (Item)((TrimMaterial)armortrim.m_266210_().m_203334_()).f_265970_().m_203334_();
                Item template = (Item)((TrimPattern)armortrim.m_266429_().m_203334_()).f_265847_().m_203334_();
                return Math.addExact(Math.addExact(currentEMC, EMCHelper.getEmcValue((ItemLike)material)), EMCHelper.getEmcValue((ItemLike)template));
            }
        }
        return currentEMC;
    }

    @Override
    @Nullable
    public CompoundTag getPersistentNBT(@NotNull ItemInfo info) {
        CompoundTag tag;
        if (info.is((TagKey<Item>)ItemTags.f_265942_) && (tag = info.getNBT()) != null && tag.m_128425_("Trim", 10)) {
            CompoundTag toReturn = new CompoundTag();
            toReturn.m_128365_("Trim", (Tag)tag.m_128469_("Trim"));
            return toReturn;
        }
        return null;
    }
}

