/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;

@EMCMapper
public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final List<IRecipeTypeMapper> recipeMappers = new ArrayList<IRecipeTypeMapper>();

    public static void loadMappers() {
        if (recipeMappers.isEmpty()) {
            recipeMappers.addAll(AnnotationHelper.getRecipeTypeMappers());
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        ResourceLocation typeRegistryName;
        NSSFake.setCurrentNamespace("craftingMapper");
        HashMap<ResourceLocation, RecipeCountInfo> recipeCount = new HashMap<ResourceLocation, RecipeCountInfo>();
        HashSet<ResourceLocation> canNotMap = new HashSet<ResourceLocation>();
        RecipeManager recipeManager = serverResources.m_206887_();
        NSSFakeGroupManager fakeGroupManager = new NSSFakeGroupManager();
        for (Map.Entry entry : ForgeRegistries.RECIPE_TYPES.getEntries()) {
            typeRegistryName = ((ResourceKey)entry.getKey()).m_135782_();
            RecipeType recipeType = (RecipeType)entry.getValue();
            boolean wasHandled = false;
            ArrayList recipes = null;
            ArrayList<Object> unhandled = new ArrayList();
            for (IRecipeTypeMapper recipeMapper : recipeMappers) {
                String configKey = this.getName() + "." + recipeMapper.getName() + ".enabled";
                if (!EMCMappingHandler.getOrSetDefault(config, configKey, recipeMapper.getDescription(), recipeMapper.isAvailable()).booleanValue() || !recipeMapper.canHandle(recipeType)) continue;
                if (recipes == null) {
                    recipes = recipeManager.m_44013_(recipeType);
                }
                int numHandled = 0;
                for (Recipe recipe : recipes) {
                    try {
                        if (recipeMapper.handleRecipe(mapper, recipe, registryAccess, fakeGroupManager)) {
                            ++numHandled;
                            continue;
                        }
                        unhandled.add(recipe);
                    }
                    catch (Exception e) {
                        PECore.LOGGER.error(LogUtils.FATAL_MARKER, "A fatal error occurred while trying to map the recipe: {}", (Object)recipe.m_6423_());
                        throw e;
                    }
                }
                if (numHandled <= 0 && !recipes.isEmpty()) continue;
                if (recipeCount.containsKey(typeRegistryName)) {
                    ((RecipeCountInfo)recipeCount.get(typeRegistryName)).setUnhandled(unhandled);
                } else {
                    recipeCount.put(typeRegistryName, new RecipeCountInfo(recipes.size(), unhandled));
                }
                wasHandled = true;
                if (unhandled.isEmpty()) break;
                recipes = unhandled;
                unhandled = new ArrayList();
            }
            if (wasHandled) continue;
            canNotMap.add(typeRegistryName);
        }
        PECore.debugLog("CraftingMapper Statistics:", new Object[0]);
        for (Map.Entry entry : recipeCount.entrySet()) {
            typeRegistryName = (ResourceLocation)entry.getKey();
            RecipeCountInfo countInfo = (RecipeCountInfo)entry.getValue();
            int total = countInfo.getTotalRecipes();
            List<Recipe<?>> unhandled = countInfo.getUnhandled();
            PECore.debugLog("Found and handled {} of {} Recipes of Type {}", total - unhandled.size(), total, typeRegistryName);
            if (unhandled.isEmpty()) continue;
            PECore.debugLog("Unhandled Recipes of Type {}:", typeRegistryName);
            for (Recipe<?> recipe : unhandled) {
                PECore.debugLog("Name: {}, Recipe class: {}", recipe.m_6423_(), recipe.getClass().getName());
            }
        }
        for (ResourceLocation resourceLocation : canNotMap) {
            PECore.debugLog("Could not map any Recipes of Type: {}", resourceLocation);
        }
        NSSFake.resetNamespace();
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.RecipeManager";
    }

    private static class NSSFakeGroupManager
    implements INSSFakeGroupManager {
        private final Map<Set<NormalizedSimpleStack>, NormalizedSimpleStack> groups = new HashMap<Set<NormalizedSimpleStack>, NormalizedSimpleStack>();
        private int fakeIndex;

        private NSSFakeGroupManager() {
        }

        @Override
        public Tuple<NormalizedSimpleStack, Boolean> getOrCreateFakeGroup(Set<NormalizedSimpleStack> normalizedSimpleStacks) {
            NormalizedSimpleStack stack = this.groups.get(normalizedSimpleStacks);
            if (stack == null) {
                stack = NSSFake.create(Integer.toString(this.fakeIndex++));
                this.groups.put(new HashSet<NormalizedSimpleStack>(normalizedSimpleStacks), stack);
                return new Tuple((Object)stack, (Object)true);
            }
            return new Tuple((Object)stack, (Object)false);
        }
    }

    private static class RecipeCountInfo {
        private final int totalRecipes;
        private List<Recipe<?>> unhandled;

        private RecipeCountInfo(int totalRecipes, List<Recipe<?>> unhandled) {
            this.totalRecipes = totalRecipes;
            this.unhandled = unhandled;
        }

        public int getTotalRecipes() {
            return this.totalRecipes;
        }

        public void setUnhandled(List<Recipe<?>> unhandled) {
            this.unhandled = unhandled;
        }

        public List<Recipe<?>> getUnhandled() {
            return this.unhandled;
        }
    }
}

