/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.emc.mappers.customConversions.json.ConversionGroup;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionDeserializer;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionFile;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValues;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValuesDeserializer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

@EMCMapper
public class CustomConversionMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomConversion.class, (Object)new CustomConversionDeserializer()).registerTypeAdapter(FixedValues.class, (Object)new FixedValuesDeserializer()).registerTypeAdapter(NormalizedSimpleStack.class, (Object)NSSSerializer.INSTANCE).setPrettyPrinting().create();

    @Override
    public String getName() {
        return "CustomConversionMapper";
    }

    @Override
    public String getDescription() {
        return "Loads json files within datapacks (data/<domain>/pe_custom_conversions/*.json) to add values and conversions";
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        Map<ResourceLocation, CustomConversionFile> files = CustomConversionMapper.load(resourceManager);
        for (CustomConversionFile file : files.values()) {
            CustomConversionMapper.addMappingsFromFile(file, mapper);
        }
    }

    private static Map<ResourceLocation, CustomConversionFile> load(ResourceManager resourceManager) {
        HashMap<ResourceLocation, CustomConversionFile> loading = new HashMap<ResourceLocation, CustomConversionFile>();
        String folder = "pe_custom_conversions";
        String extension = ".json";
        int folderLength = folder.length();
        int extensionLength = extension.length();
        for (Map.Entry entry : resourceManager.m_214160_(folder, n -> n.m_135815_().endsWith(extension)).entrySet()) {
            ResourceLocation file = (ResourceLocation)entry.getKey();
            ResourceLocation conversionId = new ResourceLocation(file.m_135827_(), file.m_135815_().substring(folderLength + 1, file.m_135815_().length() - extensionLength));
            PECore.LOGGER.info("Considering file {}, ID {}", (Object)file, (Object)conversionId);
            NSSFake.setCurrentNamespace(conversionId.toString());
            try {
                for (Resource resource : (List)entry.getValue()) {
                    CustomConversionFile result;
                    try (BufferedReader reader = resource.m_215508_();){
                        result = CustomConversionMapper.parseJson(reader);
                    }
                    catch (JsonParseException ex) {
                        PECore.LOGGER.error("Malformed JSON", (Throwable)ex);
                        continue;
                    }
                    loading.merge(conversionId, result, CustomConversionFile::merge);
                }
            }
            catch (IOException e) {
                PECore.LOGGER.error("Could not load resource {}", (Object)file, (Object)e);
            }
        }
        NSSFake.resetNamespace();
        return loading;
    }

    private static void addMappingsFromFile(CustomConversionFile file, IMappingCollector<NormalizedSimpleStack, Long> mapper) {
        NSSTag nssTag;
        NormalizedSimpleStack something;
        for (Map.Entry<String, ConversionGroup> entry : file.groups.entrySet()) {
            PECore.debugLog("Adding conversions from group '{}' with comment '{}'", entry.getKey(), entry.getValue().comment);
            for (CustomConversion conversion : entry.getValue().conversions) {
                mapper.addConversion(conversion.count, conversion.output, conversion.ingredients);
            }
        }
        for (Map.Entry<Object, Object> entry : file.values.setValueBefore.entrySet()) {
            something = (NormalizedSimpleStack)entry.getKey();
            mapper.setValueBefore(something, (Long)entry.getValue());
            if (!(something instanceof NSSTag)) continue;
            nssTag = (NSSTag)something;
            nssTag.forEachElement(normalizedSimpleStack -> mapper.setValueBefore((NormalizedSimpleStack)normalizedSimpleStack, (Long)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : file.values.setValueAfter.entrySet()) {
            something = (NormalizedSimpleStack)entry.getKey();
            mapper.setValueAfter(something, (Long)entry.getValue());
            if (!(something instanceof NSSTag)) continue;
            nssTag = (NSSTag)something;
            nssTag.forEachElement(normalizedSimpleStack -> mapper.setValueAfter((NormalizedSimpleStack)normalizedSimpleStack, (Long)entry.getValue()));
        }
        for (CustomConversion customConversion : file.values.conversion) {
            NormalizedSimpleStack out = customConversion.output;
            if (customConversion.propagateTags && out instanceof NSSTag) {
                nssTag = (NSSTag)out;
                nssTag.forEachElement(normalizedSimpleStack -> mapper.setValueFromConversion(conversion.count, (NormalizedSimpleStack)normalizedSimpleStack, conversion.ingredients));
            }
            mapper.setValueFromConversion(customConversion.count, out, customConversion.ingredients);
        }
    }

    public static CustomConversionFile parseJson(Reader json) {
        return (CustomConversionFile)GSON.fromJson((Reader)new BufferedReader(json), CustomConversionFile.class);
    }
}

