/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config.value;

import java.util.function.DoubleSupplier;
import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedDoubleValue
extends CachedValue<Double>
implements DoubleSupplier {
    private boolean resolved;
    private double cachedValue;

    private CachedDoubleValue(IPEConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        super(config, internal);
    }

    public static CachedDoubleValue wrap(IPEConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        return new CachedDoubleValue(config, internal);
    }

    public double getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Double)this.internal.getDefault();
    }

    public double get() {
        if (!this.resolved) {
            this.cachedValue = (Double)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public double getAsDouble() {
        return this.get();
    }

    public void set(double value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        double oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

