/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NSSItem
extends AbstractNBTNSSTag<Item> {
    private NSSItem(@NotNull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundTag nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        if (stack.m_41763_() && stack.m_41782_() && stack.m_41784_().equals((Object)new ItemStack((ItemLike)stack.m_41720_()).m_41783_())) {
            return NSSItem.createItem((ItemLike)stack.m_41720_(), null);
        }
        return NSSItem.createItem((ItemLike)stack.m_41720_(), stack.m_41783_());
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemLike itemProvider) {
        return NSSItem.createItem(itemProvider, null);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemLike itemProvider, @Nullable CompoundTag nbt) {
        Item item = itemProvider.m_5456_();
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName == null) {
            throw new IllegalArgumentException("Can't make an NSSItem with an unregistered item");
        }
        return NSSItem.createItem(registryName, nbt);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ResourceLocation itemID) {
        return NSSItem.createItem(itemID, null);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ResourceLocation itemID, @Nullable CompoundTag nbt) {
        return new NSSItem(itemID, false, nbt);
    }

    @NotNull
    public static NSSItem createTag(@NotNull ResourceLocation tagId) {
        return new NSSItem(tagId, true, null);
    }

    @NotNull
    public static NSSItem createTag(@NotNull TagKey<Item> tag) {
        return NSSItem.createTag(tag.f_203868_());
    }

    @Override
    protected boolean isInstance(AbstractNSSTag<?> o) {
        return o instanceof NSSItem;
    }

    @Override
    @NotNull
    public String getJsonPrefix() {
        return "";
    }

    @Override
    @NotNull
    public String getType() {
        return "Item";
    }

    @Override
    @NotNull
    protected Optional<Either<HolderSet.Named<Item>, ITag<Item>>> getTag() {
        return this.getTag(ForgeRegistries.ITEMS);
    }

    @Override
    protected Function<Item, NormalizedSimpleStack> createNew() {
        return NSSItem::createItem;
    }
}

