/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import moze_intel.projecte.api.data.ConversionBuilderNSSHelper;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class ConversionBuilder<BUILDER extends ConversionBuilder<BUILDER>>
implements ConversionBuilderNSSHelper<BUILDER> {
    private final Map<NormalizedSimpleStack, Integer> ingredients = new LinkedHashMap<NormalizedSimpleStack, Integer>();
    private final NormalizedSimpleStack output;
    private final int outputAmount;
    private boolean propagateTags;

    ConversionBuilder(@NotNull NormalizedSimpleStack output, int outputAmount) {
        this.output = output;
        this.outputAmount = outputAmount;
    }

    public String toString() {
        return this.output + " " + this.outputAmount;
    }

    private BUILDER getThis() {
        return (BUILDER)this;
    }

    public BUILDER propagateTags() {
        NSSTag nssTag;
        if (this.propagateTags) {
            throw new RuntimeException("Propagate tags has already been set, remove unnecessary call.");
        }
        NormalizedSimpleStack normalizedSimpleStack = this.output;
        if (normalizedSimpleStack instanceof NSSTag && !(nssTag = (NSSTag)normalizedSimpleStack).representsTag()) {
            throw new RuntimeException("Propagate tags can only be enabled for conversion outputs that are tags.");
        }
        this.propagateTags = true;
        return this.getThis();
    }

    @Override
    public BUILDER ingredient(@NotNull NormalizedSimpleStack input, int amount) {
        if (this.ingredients.containsKey(input)) {
            throw new RuntimeException("Conversion already contains ingredient '" + input + "', merge identical ingredients.");
        }
        if (amount == 0) {
            throw new RuntimeException("Conversion for empty ingredient '" + input + "' should be removed.");
        }
        this.ingredients.put(input, amount);
        return this.getThis();
    }

    protected void validateIngredients() {
        if (this.ingredients.isEmpty()) {
            throw new RuntimeException("Conversion does not contain any ingredients.");
        }
    }

    JsonObject serialize() {
        this.validateIngredients();
        JsonObject json = new JsonObject();
        if (this.propagateTags) {
            json.addProperty("propagateTags", Boolean.valueOf(true));
        }
        json.addProperty("output", this.output.json());
        if (this.outputAmount != 1) {
            json.addProperty("count", (Number)this.outputAmount);
        }
        if (this.ingredients.values().stream().allMatch(value -> value == 1)) {
            JsonArray jsonIngredients = new JsonArray();
            for (NormalizedSimpleStack stack : this.ingredients.keySet()) {
                jsonIngredients.add(stack.json());
            }
            json.add("ingredients", (JsonElement)jsonIngredients);
        } else {
            JsonObject jsonIngredients = new JsonObject();
            for (Map.Entry<NormalizedSimpleStack, Integer> entry : this.ingredients.entrySet()) {
                jsonIngredients.addProperty(entry.getKey().json(), (Number)entry.getValue());
            }
            json.add("ingredients", (JsonElement)jsonIngredients);
        }
        return json;
    }
}

