/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import net.minecraft.client.resources.language.I18n;

public class WebEditorServer {
    private static volatile HttpServer server;
    private static volatile int port;
    private static final Gson GSON;
    private static final String STATIC_PREFIX = "/web/";
    private static final String ASSET_BASE = "assets/oneenoughitem/web/";

    public static synchronized void startIfNeeded() {
        if (server != null) {
            return;
        }
        try {
            server = HttpServer.create(new InetSocketAddress("127.0.0.1", 0), 0);
            port = server.getAddress().getPort();
            server.createContext("/", WebEditorServer::handleIndex);
            server.createContext(STATIC_PREFIX, WebEditorServer::handleStatic);
            server.createContext("/api/load", WebEditorServer::handleApiLoad);
            server.createContext("/api/saveRules", WebEditorServer::handleApiSaveRules);
            server.createContext("/api/scanFiles", WebEditorServer::handleApiScanFiles);
            server.setExecutor(Executors.newCachedThreadPool());
            server.start();
            Oneenoughitem.LOGGER.info("Web editor server started at {}", (Object)WebEditorServer.getBaseUrl());
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to start web editor server", (Throwable)e);
        }
    }

    public static String getBaseUrl() {
        if (port <= 0) {
            return "http://127.0.0.1:0/";
        }
        return "http://127.0.0.1:" + port + "/";
    }

    private static boolean validateMethod(HttpExchange exchange, String expectedMethod) throws IOException {
        if (!expectedMethod.equalsIgnoreCase(exchange.getRequestMethod())) {
            if ("GET".equals(expectedMethod)) {
                WebEditorServer.sendText(exchange, 405, "Method Not Allowed");
            } else {
                WebEditorServer.sendJson(exchange, 405, (JsonElement)WebEditorServer.error("Method Not Allowed"));
            }
            return false;
        }
        return true;
    }

    private static JsonObject validateReplacementFile(String datapackPath, String fileName) {
        if (WebEditorServer.isBlank(datapackPath) || WebEditorServer.isBlank(fileName)) {
            return WebEditorServer.error("datapackPath and fileName are required");
        }
        Path file = WebEditorServer.resolveReplacementFile(datapackPath, fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            return WebEditorServer.error("File not found: " + file);
        }
        return null;
    }

    private static JsonArray validateJsonArray(Path file) throws IOException {
        String content = Files.readString(file, StandardCharsets.UTF_8);
        JsonElement root = JsonParser.parseString((String)content);
        if (!root.isJsonArray()) {
            return null;
        }
        return root.getAsJsonArray();
    }

    private static void handleIndex(HttpExchange exchange) throws IOException {
        if (!WebEditorServer.validateMethod(exchange, "GET")) {
            return;
        }
        try (InputStream is = WebEditorServer.getResourceStream("index.html");){
            if (is == null) {
                WebEditorServer.sendText(exchange, 500, "index.html not found");
                return;
            }
            WebEditorServer.sendStream(exchange, 200, "text/html; charset=utf-8", is);
        }
    }

    private static void handleStatic(HttpExchange exchange) throws IOException {
        if (!WebEditorServer.validateMethod(exchange, "GET")) {
            return;
        }
        String path = exchange.getRequestURI().getPath();
        if (!path.startsWith(STATIC_PREFIX)) {
            WebEditorServer.sendText(exchange, 404, "Not Found");
            return;
        }
        String name = path.substring(STATIC_PREFIX.length());
        if (name.isEmpty()) {
            WebEditorServer.sendText(exchange, 404, "Not Found");
            return;
        }
        try (InputStream is = WebEditorServer.getResourceStream(name);){
            if (is == null) {
                WebEditorServer.sendText(exchange, 404, "Not Found");
                return;
            }
            String mime = WebEditorServer.guessMime(name);
            WebEditorServer.sendStream(exchange, 200, mime, is);
        }
    }

    private static void handleApiLoad(HttpExchange exchange) throws IOException {
        try {
            String fileName;
            if (!WebEditorServer.validateMethod(exchange, "GET")) {
                return;
            }
            Map<String, String> q = WebEditorServer.parseQuery(exchange.getRequestURI().getRawQuery());
            String datapackPath = q.get("datapackPath");
            JsonObject validationError = WebEditorServer.validateReplacementFile(datapackPath, fileName = q.get("fileName"));
            if (validationError != null) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)validationError);
                return;
            }
            Path file = WebEditorServer.resolveReplacementFile(datapackPath, fileName);
            JsonArray arr = WebEditorServer.validateJsonArray(file);
            if (arr == null) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)WebEditorServer.error("File must contain a JSON array of replacements"));
                return;
            }
            JsonObject out = new JsonObject();
            out.addProperty("ok", Boolean.valueOf(true));
            out.addProperty("count", (Number)arr.size());
            out.add("replacements", (JsonElement)arr);
            WebEditorServer.sendJson(exchange, 200, (JsonElement)out);
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("API /api/load failed", (Throwable)e);
            WebEditorServer.sendJson(exchange, 500, (JsonElement)WebEditorServer.error("Internal error: " + e.getMessage()));
        }
    }

    private static void handleApiSaveRules(HttpExchange exchange) throws IOException {
        try {
            JsonObject rules;
            if (!WebEditorServer.validateMethod(exchange, "POST")) {
                return;
            }
            String body = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
            JsonObject req = JsonParser.parseString((String)body).getAsJsonObject();
            String datapackPath = WebEditorServer.optString(req, "datapackPath");
            String fileName = WebEditorServer.optString(req, "fileName");
            Integer index = WebEditorServer.optInt(req, "index");
            JsonObject jsonObject = rules = req.has("rules") && req.get("rules").isJsonObject() ? req.getAsJsonObject("rules") : null;
            if (WebEditorServer.isBlank(datapackPath) || WebEditorServer.isBlank(fileName) || index == null || index < 0) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)WebEditorServer.error("datapackPath, fileName and valid index are required"));
                return;
            }
            JsonObject validationError = WebEditorServer.validateReplacementFile(datapackPath, fileName);
            if (validationError != null) {
                WebEditorServer.sendJson(exchange, 404, (JsonElement)validationError);
                return;
            }
            Path file = WebEditorServer.resolveReplacementFile(datapackPath, fileName);
            JsonArray arr = WebEditorServer.validateJsonArray(file);
            if (arr == null) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)WebEditorServer.error("File must contain a JSON array of replacements"));
                return;
            }
            if (index >= arr.size()) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)WebEditorServer.error("index out of range"));
                return;
            }
            JsonObject item = arr.get(index.intValue()).getAsJsonObject();
            if (rules == null) {
                item.remove("rules");
            } else {
                item.add("rules", (JsonElement)rules);
            }
            String pretty = GSON.toJson((JsonElement)arr);
            Files.writeString(file, (CharSequence)pretty, StandardCharsets.UTF_8, new OpenOption[0]);
            JsonObject out = new JsonObject();
            out.addProperty("ok", Boolean.valueOf(true));
            WebEditorServer.sendJson(exchange, 200, (JsonElement)out);
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("API /api/saveRules failed", (Throwable)e);
            WebEditorServer.sendJson(exchange, 500, (JsonElement)WebEditorServer.error("Internal error: " + e.getMessage()));
        }
    }

    private static void handleApiScanFiles(HttpExchange exchange) throws IOException {
        try {
            if (!WebEditorServer.validateMethod(exchange, "GET")) {
                return;
            }
            Map<String, String> q = WebEditorServer.parseQuery(exchange.getRequestURI().getRawQuery());
            String datapackPath = q.get("datapackPath");
            if (WebEditorServer.isBlank(datapackPath)) {
                WebEditorServer.sendJson(exchange, 400, (JsonElement)WebEditorServer.error("datapackPath is required"));
                return;
            }
            Path replacementsDir = Paths.get(datapackPath, new String[0]);
            JsonArray files = new JsonArray();
            if (Files.exists(replacementsDir, new LinkOption[0]) && Files.isDirectory(replacementsDir, new LinkOption[0])) {
                try {
                    Files.list(replacementsDir).filter(p -> p.toString().toLowerCase().endsWith(".json")).sorted().forEach(p -> {
                        String fileName = p.getFileName().toString();
                        JsonObject fileInfo = new JsonObject();
                        fileInfo.addProperty("name", fileName);
                        fileInfo.addProperty("displayName", fileName.replaceAll("\\.json$", ""));
                        try {
                            String content = Files.readString(p, StandardCharsets.UTF_8);
                            JsonElement root = JsonParser.parseString((String)content);
                            if (root.isJsonArray()) {
                                fileInfo.addProperty("count", (Number)root.getAsJsonArray().size());
                            } else {
                                fileInfo.addProperty("count", (Number)0);
                            }
                        }
                        catch (Exception e) {
                            fileInfo.addProperty("count", (Number)-1);
                            Oneenoughitem.LOGGER.warn("Failed to parse JSON file: {}", p, (Object)e);
                        }
                        files.add((JsonElement)fileInfo);
                    });
                }
                catch (IOException e) {
                    Oneenoughitem.LOGGER.warn("Failed to scan directory: {}", (Object)replacementsDir, (Object)e);
                    WebEditorServer.sendJson(exchange, 500, (JsonElement)WebEditorServer.error("Failed to scan directory: " + e.getMessage()));
                    return;
                }
            } else {
                Oneenoughitem.LOGGER.warn("Replacements directory not found or not a directory: {}", (Object)replacementsDir);
            }
            JsonObject out = new JsonObject();
            out.addProperty("ok", Boolean.valueOf(true));
            out.add("files", (JsonElement)files);
            WebEditorServer.sendJson(exchange, 200, (JsonElement)out);
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("API /api/scanFiles failed", (Throwable)e);
            WebEditorServer.sendJson(exchange, 500, (JsonElement)WebEditorServer.error("Internal error: " + e.getMessage()));
        }
    }

    private static Path resolveReplacementFile(String datapackPath, String fileName) {
        Path base = Paths.get(datapackPath, new String[0]);
        Object normalized = fileName.endsWith(".json") ? fileName : fileName + ".json";
        return base.resolve((String)normalized);
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static JsonObject error(String msg) {
        JsonObject obj = new JsonObject();
        obj.addProperty("ok", Boolean.valueOf(false));
        obj.addProperty("error", msg);
        return obj;
    }

    private static Map<String, String> parseQuery(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (raw == null || raw.isEmpty()) {
            return map;
        }
        for (String part : raw.split("&")) {
            int i = part.indexOf(61);
            if (i >= 0) {
                String k = WebEditorServer.urlDecode(part.substring(0, i));
                String v = WebEditorServer.urlDecode(part.substring(i + 1));
                map.put(k, v);
                continue;
            }
            map.put(WebEditorServer.urlDecode(part), "");
        }
        return map;
    }

    private static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return s;
        }
    }

    private static String guessMime(String name) {
        String lower = name.toLowerCase(Locale.ROOT);
        if (lower.endsWith(".js")) {
            return "application/javascript; charset=utf-8";
        }
        if (lower.endsWith(".css")) {
            return "text/css; charset=utf-8";
        }
        if (lower.endsWith(".html")) {
            return "text/html; charset=utf-8";
        }
        if (lower.endsWith(".png")) {
            return "image/png";
        }
        if (lower.endsWith(".jpg") || lower.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lower.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return "application/octet-stream";
    }

    private static InputStream getResourceStream(String name) {
        String path = ASSET_BASE + name;
        ClassLoader cl = WebEditorServer.class.getClassLoader();
        return cl.getResourceAsStream(path);
    }

    private static void sendStream(HttpExchange ex, int code, String contentType, InputStream is) throws IOException {
        Headers h = ex.getResponseHeaders();
        h.set("Content-Type", contentType);
        byte[] data = is.readAllBytes();
        ex.sendResponseHeaders(code, data.length);
        try (OutputStream os = ex.getResponseBody();){
            os.write(data);
        }
    }

    private static void sendText(HttpExchange ex, int code, String text) throws IOException {
        Headers h = ex.getResponseHeaders();
        h.set("Content-Type", "text/plain; charset=utf-8");
        byte[] data = text.getBytes(StandardCharsets.UTF_8);
        ex.sendResponseHeaders(code, data.length);
        try (OutputStream os = ex.getResponseBody();){
            os.write(data);
        }
    }

    private static void sendJson(HttpExchange ex, int code, JsonElement json) throws IOException {
        Headers h = ex.getResponseHeaders();
        h.set("Content-Type", "application/json; charset=utf-8");
        byte[] data = GSON.toJson(json).getBytes(StandardCharsets.UTF_8);
        ex.sendResponseHeaders(code, data.length);
        try (OutputStream os = ex.getResponseBody();){
            os.write(data);
        }
    }

    private static String optString(JsonObject o, String k) {
        return o.has(k) && !o.get(k).isJsonNull() ? o.get(k).getAsString() : null;
    }

    private static Integer optInt(JsonObject o, String k) {
        try {
            return o.has(k) && !o.get(k).isJsonNull() ? Integer.valueOf(o.get(k).getAsInt()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void copyToClipboard(String text) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                new ProcessBuilder("cmd", "/c", "echo " + text + " | clip").start();
            } else if (os.contains("mac")) {
                Process p = new ProcessBuilder("pbcopy").start();
                p.getOutputStream().write(text.getBytes(StandardCharsets.UTF_8));
                p.getOutputStream().close();
            } else if (os.contains("nix") || os.contains("nux")) {
                Process p = new ProcessBuilder("xclip", "-selection", "clipboard").start();
                p.getOutputStream().write(text.getBytes(StandardCharsets.UTF_8));
                p.getOutputStream().close();
            } else {
                Oneenoughitem.LOGGER.info("Unknown OS, cannot auto copy. URL: {}", (Object)text);
            }
            Oneenoughitem.LOGGER.info("\u5c1d\u8bd5\u81ea\u52a8\u590d\u5236 URL \u5230\u526a\u8d34\u677f: {}", (Object)text);
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("\u81ea\u52a8\u590d\u5236\u5931\u8d25, URL: {}", (Object)text, (Object)e);
        }
    }

    public static void openInBrowserFallback(String url) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url).start();
            } else if (os.contains("mac")) {
                new ProcessBuilder("open", url).start();
            } else if (os.contains("nix") || os.contains("nux")) {
                new ProcessBuilder("xdg-open", url).start();
            } else {
                Oneenoughitem.LOGGER.info("Unknown OS, please open manually: {}", (Object)url);
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Failed to launch browser for {}", (Object)url, (Object)e);
        }
    }

    public static String openInBrowser() {
        WebEditorServer.startIfNeeded();
        String url = WebEditorServer.getBaseUrl();
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create(url));
                return null;
            }
            WebEditorServer.copyToClipboard(url);
            WebEditorServer.openInBrowserFallback(url);
            return I18n.m_118938_((String)"oneenoughitem.webeditor.open_browser", (Object[])new Object[]{url});
        }
        catch (Exception e) {
            WebEditorServer.copyToClipboard(url);
            WebEditorServer.openInBrowserFallback(url);
            Oneenoughitem.LOGGER.warn("Failed to open browser for {}", (Object)url, (Object)e);
            return I18n.m_118938_((String)"oneenoughitem.webeditor.open_browser_manual", (Object[])new Object[]{url});
        }
    }

    static {
        port = -1;
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

