/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.init;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemReplacementCache {
    private static final ConcurrentHashMap<String, String> ItemMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> TagMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> ItemRulesCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> TagRulesCache = new ConcurrentHashMap();
    private static volatile Map<String, String> ReloadOverrideItemMap = null;

    public static String matchItem(String id) {
        return ((Map)Objects.requireNonNullElse(ReloadOverrideItemMap, ItemMapCache)).getOrDefault(id, null);
    }

    public static String matchTag(String tagId) {
        return TagMapCache.getOrDefault(tagId, null);
    }

    public static String matchTag(ResourceLocation tagId) {
        return tagId != null ? ItemReplacementCache.matchTag(tagId.toString()) : null;
    }

    public static boolean isTagReplaced(String tagId) {
        return tagId != null && TagMapCache.containsKey(tagId);
    }

    public static boolean isTagReplaced(ResourceLocation tagId) {
        return tagId != null && ItemReplacementCache.isTagReplaced(tagId.toString());
    }

    public static Optional<Replacements.Rules> getItemRules(String itemId) {
        return Optional.ofNullable(ItemRulesCache.get(itemId));
    }

    public static Optional<Replacements.Rules> getTagRules(String tagId) {
        return Optional.ofNullable(TagRulesCache.get(tagId));
    }

    private static Optional<Replacements.Rules> getGlobalDefaultRules() {
        try {
            DomainConfig.DefaultRules cfg = OEIConfig.getDefaultRules("oei");
            if (cfg != null) {
                return Optional.of(cfg.toRules());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static boolean shouldReplaceInDataDir(String itemId, String directory) {
        return ItemReplacementCache.getItemRules(itemId).or(ItemReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::data).map(dataRules -> (Replacements.ProcessingMode)((Object)((Object)dataRules.get(directory)))).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static boolean shouldReplaceInTagType(String itemId, String tagType) {
        return ItemReplacementCache.getItemRules(itemId).or(ItemReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::tag).map(tagRules -> (Replacements.ProcessingMode)((Object)((Object)tagRules.get(tagType)))).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static void putReplacement(Replacements replacement) {
        List<Item> resolvedItems = Utils.resolveItemList(replacement.match());
        for (Item item : resolvedItems) {
            String id = Utils.getItemRegistryName(item);
            if (id == null) continue;
            ItemMapCache.put(id, replacement.result());
            replacement.rules().ifPresent(rules -> ItemRulesCache.put(id, (Replacements.Rules)rules));
            Oneenoughitem.LOGGER.debug("Added item replacement mapping: {} -> {}", (Object)id, (Object)replacement.result());
        }
        for (String matchItem : replacement.match()) {
            if (!matchItem.startsWith("#")) continue;
            String tagId = matchItem.substring(1);
            TagMapCache.put(tagId, replacement.result());
            replacement.rules().ifPresent(rules -> TagRulesCache.put(tagId, (Replacements.Rules)rules));
            Oneenoughitem.LOGGER.debug("Added tag replacement mapping: {} -> {}", (Object)tagId, (Object)replacement.result());
        }
        if (resolvedItems.isEmpty() && replacement.match().stream().noneMatch(s -> s.startsWith("#"))) {
            Oneenoughitem.LOGGER.warn("No valid items or tags resolved from match: {}", replacement.match());
        } else {
            int tagCount = (int)replacement.match().stream().filter(s -> s.startsWith("#")).count();
            Oneenoughitem.LOGGER.info("Added replacement rule for {} items and {} tags: {} -> {}", (Object)resolvedItems.size(), (Object)tagCount, replacement.match(), (Object)replacement.result());
        }
    }

    public static boolean hasAnyMappings() {
        return !ItemMapCache.isEmpty() || !TagMapCache.isEmpty();
    }

    public static boolean isSourceItemId(String id) {
        if (id == null) {
            return false;
        }
        return ((Map)Objects.requireNonNullElse(ReloadOverrideItemMap, ItemMapCache)).containsKey(id);
    }

    public static boolean isSourceTagId(String id) {
        return id != null && TagMapCache.containsKey(id);
    }

    public static void clearCache() {
        int previousItemSize = ItemMapCache.size();
        int previousTagSize = TagMapCache.size();
        ItemMapCache.clear();
        TagMapCache.clear();
        ItemRulesCache.clear();
        TagRulesCache.clear();
        if (previousItemSize > 0 || previousTagSize > 0) {
            Oneenoughitem.LOGGER.info("Cleared {} cached item mappings and {} cached tag mappings", (Object)previousItemSize, (Object)previousTagSize);
        }
    }

    public static boolean removeItemReplacement(String itemId) {
        if (itemId != null && ItemMapCache.containsKey(itemId)) {
            String removed = ItemMapCache.remove(itemId);
            ItemRulesCache.remove(itemId);
            Oneenoughitem.LOGGER.debug("Removed item replacement from runtime cache: {} -> {}", (Object)itemId, (Object)removed);
            return true;
        }
        return false;
    }

    public static boolean removeTagReplacement(String tagId) {
        if (tagId != null && TagMapCache.containsKey(tagId)) {
            String removed = TagMapCache.remove(tagId);
            TagRulesCache.remove(tagId);
            Oneenoughitem.LOGGER.debug("Removed tag replacement from runtime cache: {} -> {}", (Object)tagId, (Object)removed);
            return true;
        }
        return false;
    }

    public static void removeReplacements(Collection<String> itemIds, Collection<String> tagIds) {
        boolean changed = false;
        if (itemIds != null) {
            for (String itemId : itemIds) {
                if (!ItemReplacementCache.removeItemReplacement(itemId)) continue;
                changed = true;
            }
        }
        if (tagIds != null) {
            for (String tagId : tagIds) {
                if (!ItemReplacementCache.removeTagReplacement(tagId)) continue;
                changed = true;
            }
        }
        if (changed) {
            Oneenoughitem.LOGGER.info("Removed {} item replacements and {} tag replacements from runtime cache", (Object)(itemIds != null ? itemIds.size() : 0), (Object)(tagIds != null ? tagIds.size() : 0));
        }
    }

    public static Collection<String> trackSourceIdOf(String id) {
        HashSet<String> result = new HashSet<String>();
        ItemMapCache.forEach((matchItem, resultItem) -> {
            if (resultItem.equals(id)) {
                result.add((String)matchItem);
            }
        });
        return result;
    }

    public static Collection<Item> trackSourceOf(String id) {
        HashSet<Item> result = new HashSet<Item>();
        ItemMapCache.forEach((matchItem, resultItem) -> {
            if (resultItem.equals(id)) {
                result.add(Utils.getItemById(matchItem));
            }
        });
        return result;
    }

    public static void beginReloadOverride(Map<String, String> currentItemMap) {
        if (currentItemMap == null || currentItemMap.isEmpty()) {
            ReloadOverrideItemMap = null;
            return;
        }
        ReloadOverrideItemMap = new HashMap<String, String>(currentItemMap);
        Oneenoughitem.LOGGER.info("Enabled reload-override mapping for this resource reload: {} items", (Object)ReloadOverrideItemMap.size());
    }

    public static void endReloadOverride() {
        if (ReloadOverrideItemMap != null) {
            Oneenoughitem.LOGGER.info("Disabled reload-override mapping: {} entries", (Object)ReloadOverrideItemMap.size());
        }
        ReloadOverrideItemMap = null;
    }

    public static boolean hasReloadOverride() {
        return ReloadOverrideItemMap != null;
    }
}

