/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.data;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.ValidationStreams;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class Validators {
    private Validators() {
    }

    public static ValidationStreams.Accumulator fromItem(String itemId, ResourceLocation source) {
        if (itemId.startsWith("#")) {
            return Validators.fromTag(itemId.substring(1), source);
        }
        return Utils.getItemById(itemId) != null ? ValidationStreams.Accumulator.valid(1) : ValidationStreams.Accumulator.invalid();
    }

    public static ValidationStreams.Accumulator fromTag(String tagIdString, ResourceLocation source) {
        try {
            ResourceLocation tagId = new ResourceLocation(tagIdString);
            if (Utils.isTagExists(tagId)) {
                Collection<Item> tagItems = Utils.getItemsOfTag(tagId);
                if (!tagItems.isEmpty()) {
                    Oneenoughitem.LOGGER.debug("Valid tag in {}: '{}' contains {} items", (Object)source, (Object)tagId, (Object)tagItems.size());
                    return ValidationStreams.Accumulator.valid(tagItems.size());
                }
                Oneenoughitem.LOGGER.warn("Tag in {} is empty: '{}'", (Object)source, (Object)tagId);
                return ValidationStreams.Accumulator.invalid();
            }
            Oneenoughitem.LOGGER.debug("Tag in {} not found (may be uninitialized): '{}'", (Object)source, (Object)tagId);
            return ValidationStreams.Accumulator.deferred();
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.error("Invalid tag format in {}: '{}'", (Object)source, (Object)tagIdString, (Object)e);
            return ValidationStreams.Accumulator.failure("Invalid tag format: " + tagIdString);
        }
    }
}

