/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.data;

import com.mafuyu404.oelib.api.data.DataDriven;
import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@DataDriven(folder="replacements", syncToClient=true, supportArray=true)
public record Replacements(List<String> match, String result, Optional<Rules> rules) {
    public static final Codec<Replacements> CODEC = new Codec<Replacements>(){

        public <T> DataResult<Pair<Replacements, T>> decode(DynamicOps<T> ops, T input) {
            Dynamic dyn = new Dynamic(ops, input);
            return dyn.getMapValues().flatMap(map -> {
                List match = null;
                String resultStr = null;
                Optional[] rulesHolder = new Optional[]{Optional.empty()};
                for (Map.Entry entry : map.entrySet()) {
                    String key = ((Dynamic)entry.getKey()).asString().result().orElse(null);
                    if (key == null) continue;
                    Dynamic valueDyn = (Dynamic)entry.getValue();
                    for (String mk : Replacements.matchKeys()) {
                        if (!key.equals(mk)) continue;
                        match = valueDyn.asStreamOpt().map(stream -> stream.map(d -> d.asString().result().orElse(null)).filter(Objects::nonNull).toList()).result().orElse(Collections.emptyList());
                        break;
                    }
                    for (String rk : Replacements.resultKeys()) {
                        if (!key.equals(rk)) continue;
                        resultStr = valueDyn.asString().result().orElse(null);
                        break;
                    }
                    if (!"rules".equals(key)) continue;
                    Rules.CODEC.decode(ops, valueDyn.getValue()).result().ifPresent(p -> {
                        rulesHolder[0] = Optional.of((Rules)p.getFirst());
                    });
                }
                if (match == null || resultStr == null) {
                    return DataResult.error(() -> "Missing match or result field in Replacements");
                }
                Replacements replacements = new Replacements(match, resultStr, rulesHolder[0]);
                return DataResult.success((Object)Pair.of((Object)replacements, (Object)dyn.getValue()));
            });
        }

        public <T> DataResult<T> encode(Replacements value, DynamicOps<T> ops, T prefix) {
            try {
                String did = DomainRegistry.currentDataId();
                String mk = "match" + Replacements.cap(did);
                String rk = "result" + Replacements.cap(did);
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                Object matchList = ops.createList(value.match().stream().map(arg_0 -> ops.createString(arg_0)));
                map.put(ops.createString(mk), matchList);
                map.put(ops.createString(rk), ops.createString(value.result()));
                value.rules().flatMap(r -> Rules.CODEC.encodeStart(ops, r).result()).ifPresent(encodedRules -> map.put(ops.createString("rules"), encodedRules));
                return DataResult.success((Object)ops.createMap(map));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Failed to encode Replacements: " + e.getMessage());
            }
        }
    };

    private static Set<String> matchKeys() {
        return DomainRegistry.all().values().stream().map(a -> "match" + Replacements.cap(a.dataId())).collect(Collectors.toSet());
    }

    private static Set<String> resultKeys() {
        return DomainRegistry.all().values().stream().map(a -> "result" + Replacements.cap(a.dataId())).collect(Collectors.toSet());
    }

    private static String cap(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public record Rules(Optional<Map<String, ProcessingMode>> data, Optional<Map<String, ProcessingMode>> tag) {
        public static final Codec<Rules> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, ProcessingMode.CODEC).optionalFieldOf("data").forGetter(Rules::data), (App)Codec.unboundedMap((Codec)Codec.STRING, ProcessingMode.CODEC).optionalFieldOf("tag").forGetter(Rules::tag)).apply((Applicative)instance, Rules::new));
    }

    public static enum ProcessingMode {
        REPLACE,
        RETAIN;

        public static final Codec<ProcessingMode> CODEC;

        static {
            CODEC = Codec.STRING.flatXmap(name -> {
                try {
                    return DataResult.success((Object)((Object)ProcessingMode.valueOf(name.toUpperCase())));
                }
                catch (IllegalArgumentException e) {
                    return DataResult.error(() -> "Invalid processing mode: " + name);
                }
            }, mode -> DataResult.success((Object)mode.name().toLowerCase()));
        }
    }
}

