/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.util;

import com.mafuyu404.oneenoughitem.client.gui.cache.ItemGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReplacementUtils {
    public static ReplacementInfo getReplacementInfo(String itemId) {
        if (itemId == null) {
            return ReplacementInfo.EMPTY;
        }
        String runtimeReplacement = ItemReplacementCache.matchItem(itemId);
        if (runtimeReplacement != null) {
            return new ReplacementInfo(true, runtimeReplacement, true, ItemGlobalReplacementCache.get().isDataUsedAsResult(itemId));
        }
        String globalReplacement = ItemGlobalReplacementCache.get().getDataReplacement(itemId);
        if (globalReplacement != null) {
            return new ReplacementInfo(true, globalReplacement, false, ItemGlobalReplacementCache.get().isDataUsedAsResult(itemId));
        }
        return new ReplacementInfo(false, null, false, ItemGlobalReplacementCache.get().isDataUsedAsResult(itemId));
    }

    public static ReplacementInfo getTagReplacementInfo(ResourceLocation tagId) {
        String runtimeReplacement = ItemReplacementCache.matchTag(tagId);
        if (runtimeReplacement != null) {
            return new ReplacementInfo(true, runtimeReplacement, true, false);
        }
        String globalReplacement = ItemGlobalReplacementCache.get().getTagReplacement(tagId.toString());
        if (globalReplacement != null) {
            return new ReplacementInfo(true, globalReplacement, false, false);
        }
        return ReplacementInfo.EMPTY;
    }

    public static class ReplacementInfo {
        public static final ReplacementInfo EMPTY = new ReplacementInfo(false, null, false, false);
        private final boolean isReplaced;
        private final String replacement;
        private final boolean isRuntime;
        private final boolean isUsedAsResult;

        public ReplacementInfo(boolean isReplaced, String replacement, boolean isRuntime, boolean isUsedAsResult) {
            this.isReplaced = isReplaced;
            this.replacement = replacement;
            this.isRuntime = isRuntime;
            this.isUsedAsResult = isUsedAsResult;
        }

        public boolean isReplaced() {
            return this.isReplaced;
        }

        public boolean isUsedAsResult() {
            return this.isUsedAsResult;
        }

        public void addToTooltip(List<Component> tooltip) {
            if (this.isReplaced) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.oneenoughitem.item_replaced").m_130940_(ChatFormatting.RED));
                if (this.replacement.startsWith("#")) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.oneenoughitem.replaced_with_tag", (Object[])new Object[]{this.replacement}).m_130940_(ChatFormatting.RED));
                } else {
                    Item replacementItem = Utils.getItemById(this.replacement);
                    if (replacementItem != null) {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.oneenoughitem.replaced_with_item", (Object[])new Object[]{new ItemStack((ItemLike)replacementItem).m_41786_().getString()}).m_130940_(ChatFormatting.AQUA));
                    } else {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.oneenoughitem.replaced_with_item", (Object[])new Object[]{this.replacement}).m_130940_(ChatFormatting.AQUA));
                    }
                }
                tooltip.add((Component)Component.m_237115_((String)(this.isRuntime ? "tooltip.oneenoughitem.source_runtime" : "tooltip.oneenoughitem.source_saved")).m_130940_(ChatFormatting.YELLOW));
            }
            if (this.isUsedAsResult) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.oneenoughitem.item_used_as_result").m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public static class ReplacementIndicator {
        public static void renderItemReplaced(GuiGraphics graphics, int x, int y) {
            graphics.m_280509_(x, y, x + 5, y + 5, -65536);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, "R", x + 1, y, -1, false);
        }

        public static void renderItemUsedAsResult(GuiGraphics graphics, int x, int y) {
            graphics.m_280509_(x, y, x + 5, y + 5, -16733696);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, "T", x + 1, y, -1, false);
        }

        public static void renderTagReplaced(GuiGraphics graphics, int x, int y) {
            graphics.m_280509_(x, y, x + 15, y + 15, -65536);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, "R", x + 5, y + 4, -1, false);
        }

        public static void renderTagUsedAsResult(GuiGraphics graphics, int x, int y) {
            graphics.m_280509_(x, y, x + 15, y + 15, -16733696);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, "T", x + 5, y + 4, -1, false);
        }
    }
}

