/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.editor;

import com.mafuyu404.oneenoughitem.client.gui.components.DataDisplayWidget;
import com.mafuyu404.oneenoughitem.client.gui.components.ScrollablePanel;
import com.mafuyu404.oneenoughitem.client.gui.components.TagDisplayWidget;
import java.util.List;

public class PanelsLayoutHelper {
    private static final int ITEM_SIZE = 18;
    private static final int ITEM_SPACING = 2;
    private static final int CONTENT_OFFSET_Y = 2;
    private static final int ITEMS_PER_ROW = 10;
    private static final int TAG_COLS = 2;
    private static final int TAG_SPACING_X = 8;
    private static final int TAG_ROW_HEIGHT = 20;
    private static final int FOUR_ROWS_VISIBLE_HEIGHT = 80;

    public void rebuildPanels(ScrollablePanel matchPanel, ScrollablePanel resultPanel, List<DataDisplayWidget> matchItemWidgets, List<TagDisplayWidget> matchTagWidgets, DataDisplayWidget resultItemWidget, TagDisplayWidget resultTagWidget) {
        matchPanel.clearWidgets();
        resultPanel.clearWidgets();
        int index = 0;
        for (DataDisplayWidget dataDisplayWidget : matchItemWidgets) {
            int row = index / 10;
            int col = index % 10;
            int x = matchPanel.m_252754_() + col * 20;
            int y = matchPanel.m_252907_() + 2 + row * 20;
            dataDisplayWidget.m_264152_(x, y);
            matchPanel.addWidget(dataDisplayWidget);
            ++index;
        }
        int tagStartY = 2 + (matchItemWidgets.size() + 10 - 1) / 10 * 20 + 10;
        index = 0;
        for (TagDisplayWidget widget : matchTagWidgets) {
            int row = index / 2;
            int col = index % 2;
            int widgetW = widget.m_5711_();
            int widgetH = widget.m_93694_();
            int x = matchPanel.m_252754_() + col * (widgetW + 8);
            int y = matchPanel.m_252907_() + tagStartY + row * (widgetH + 4);
            widget.m_264152_(x, y);
            matchPanel.addWidget(widget);
            ++index;
        }
        if (resultItemWidget != null) {
            resultItemWidget.m_264152_(resultPanel.m_252754_() + resultPanel.m_5711_() / 2 - 9, resultPanel.m_252907_() + 28);
            resultPanel.addWidget(resultItemWidget);
        }
        if (resultTagWidget != null) {
            resultTagWidget.m_264152_(resultPanel.m_252754_() + resultPanel.m_5711_() / 2 - 35, resultPanel.m_252907_() + 28);
            resultPanel.addWidget(resultTagWidget);
        }
        int n = PanelsLayoutHelper.getVisibleHeight(matchItemWidgets, matchTagWidgets);
        matchPanel.setVisibleHeight(n);
        matchPanel.updateWidgetPositions();
        resultPanel.updateWidgetPositions();
    }

    private static int getVisibleHeight(List<DataDisplayWidget> matchItemWidgets, List<TagDisplayWidget> matchTagWidgets) {
        int itemsRows = (matchItemWidgets.size() + 10 - 1) / 10;
        int itemsBottom = itemsRows > 0 ? 2 + (itemsRows - 1) * 20 + 18 : 0;
        int tagsBottom = 0;
        int tagRows = (matchTagWidgets.size() + 2 - 1) / 2;
        if (tagRows > 0) {
            int tagStart = 2 + itemsRows * 20 + 10;
            tagsBottom = tagStart + (tagRows - 1) * 24 + 20;
        }
        int contentHeight = Math.max(itemsBottom, tagsBottom);
        int visibleHeight = Math.min(contentHeight, 80);
        return visibleHeight;
    }
}

