/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class FileListWidget
extends ObjectSelectionList<FileEntry> {
    private final BiConsumer<Path, Integer> onFileSelect;
    private FileEntry selectedEntry = null;
    private final List<Button> actionButtons = new ArrayList<Button>();

    public FileListWidget(Minecraft minecraft, int width, int height, int y, int itemHeight, BiConsumer<Path, Integer> onFileSelect) {
        super(minecraft, width, height, y, y + height, itemHeight);
        this.m_93488_(false);
        this.m_93496_(false);
        this.onFileSelect = onFileSelect;
    }

    public void setFiles(List<PathUtils.FileInfo> files) {
        this.m_93516_();
        this.clearActionButtons();
        for (PathUtils.FileInfo file : files) {
            this.m_7085_((AbstractSelectionList.Entry)new FileEntry(file));
        }
    }

    private void clearActionButtons() {
        this.actionButtons.clear();
        this.selectedEntry = null;
    }

    private void showActionButtons(FileEntry entry) {
        this.clearActionButtons();
        this.selectedEntry = entry;
        int entryIndex = this.m_6702_().indexOf((Object)entry);
        int entryX = this.m_5747_();
        int entryY = this.m_7610_(entryIndex);
        int entryWidth = this.m_5759_();
        int entryHeight = this.f_93387_;
        int fileNameX = entryX + 16;
        String fileName = entry.fileInfo.displayName();
        String datapackName = "[" + entry.fileInfo.datapackName() + "]";
        String fullPath = entry.fileInfo.fullPath();
        int fileNameWidth = this.f_93386_.f_91062_.m_92895_(fileName);
        int datapackWidth = this.f_93386_.f_91062_.m_92895_(datapackName);
        int pathWidth = this.f_93386_.f_91062_.m_92895_(fullPath);
        int pathX = fileNameX + datapackWidth + 5;
        int contentEndX = Math.max(fileNameX + fileNameWidth, pathX + pathWidth);
        int buttonWidth = 30;
        int buttonHeight = 12;
        int spacing = 2;
        int buttonStartX = contentEndX + 8;
        int maxButtonX = entryX + entryWidth - (buttonWidth * 3 + spacing * 2 + 5);
        if (buttonStartX > maxButtonX) {
            buttonStartX = maxButtonX;
        }
        int buttonY = entryY + (entryHeight - buttonHeight) / 2;
        Button addButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_button"), btn -> this.onFileSelect.accept(entry.fileInfo.filePath(), 0), buttonStartX, buttonY, buttonWidth, buttonHeight);
        Button editButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.modify_button"), btn -> this.onFileSelect.accept(entry.fileInfo.filePath(), 1), buttonStartX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight);
        Button deleteButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.remove_button"), btn -> this.onFileSelect.accept(entry.fileInfo.filePath(), 2), buttonStartX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, buttonHeight);
        this.actionButtons.add(addButton);
        this.actionButtons.add(editButton);
        this.actionButtons.add(deleteButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        for (Button button : this.actionButtons) {
            button.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Button actionButton : this.actionButtons) {
            if (!actionButton.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public class FileEntry
    extends ObjectSelectionList.Entry<FileEntry> {
        private final PathUtils.FileInfo fileInfo;

        public FileEntry(PathUtils.FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            boolean isSelected = FileListWidget.this.selectedEntry == this;
            GuiUtils.drawFileEntryBackground(graphics, x, y, entryWidth, entryHeight, isMouseOver, isSelected);
            String fileName = this.fileInfo.displayName();
            String iconChar = fileName.isEmpty() ? "?" : String.valueOf(fileName.charAt(0)).toUpperCase();
            GuiUtils.drawFileIcon(graphics, x + 1, y + 4, iconChar);
            int fileNameX = x + 16;
            graphics.m_280488_(((FileListWidget)FileListWidget.this).f_93386_.f_91062_, fileName, fileNameX, y + 2, 0xFFFFFF);
            String datapackName = "[" + this.fileInfo.datapackName() + "]";
            graphics.m_280488_(((FileListWidget)FileListWidget.this).f_93386_.f_91062_, datapackName, fileNameX, y + 12, 0xAAAAAA);
            String fullPath = this.fileInfo.fullPath();
            int pathX = fileNameX + ((FileListWidget)FileListWidget.this).f_93386_.f_91062_.m_92895_(datapackName) + 5;
            graphics.m_280488_(((FileListWidget)FileListWidget.this).f_93386_.f_91062_, fullPath, pathX, y + 12, 0x888888);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                FileListWidget.this.showActionButtons(this);
                return true;
            }
            return false;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)(this.fileInfo.displayName() + " in " + this.fileInfo.datapackName()));
        }
    }
}

