/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.BaseCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class EditorCache
extends BaseCache {
    private static final EditorCache INSTANCE = new EditorCache();

    private EditorCache() {
        super("oei", "editor_cache.dat", 2);
    }

    @Override
    protected void onInitialized() {
    }

    @Override
    protected void onVersionMismatch(int foundVersion) {
        Oneenoughitem.LOGGER.warn("Editor cache version mismatch (expected {}, found {}), ignoring cache", (Object)this.cacheVersion, (Object)foundVersion);
    }

    @Override
    protected void onLoadError(IOException e) {
        Oneenoughitem.LOGGER.error("Failed to load editor cache from: {}", (Object)this.cacheFile, (Object)e);
    }

    @Override
    protected void loadData(DataInputStream dis) throws IOException {
        throw new UnsupportedOperationException("Use loadCache() method instead");
    }

    @Override
    protected void saveData(DataOutputStream dos) throws IOException {
        throw new UnsupportedOperationException("Use saveCache() method instead");
    }

    public static void saveCache(Set<String> matchDataIds, Set<ResourceLocation> matchTags, String resultDataId, ResourceLocation resultTag, String fileName) {
        INSTANCE.withWriteLock(() -> {
            Path tempFile = EditorCache.INSTANCE.cacheFile.resolveSibling(EditorCache.INSTANCE.cacheFile.getFileName() + ".tmp");
            try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0])));){
                dos.writeInt(EditorCache.INSTANCE.cacheVersion);
                EditorCache.writeStringSet(dos, matchDataIds);
                Set<String> tagStrings = matchTags != null ? matchTags.stream().map(ResourceLocation::toString).collect(Collectors.toSet()) : Collections.emptySet();
                EditorCache.writeStringSet(dos, tagStrings);
                dos.writeUTF(EditorCache.nullToEmpty(resultDataId));
                dos.writeUTF(EditorCache.nullToEmpty(resultTag != null ? resultTag.toString() : null));
                dos.writeUTF(EditorCache.nullToEmpty(fileName));
                dos.flush();
            }
            catch (IOException e) {
                EditorCache.logSaveError(e);
                return;
            }
            try {
                Files.move(tempFile, EditorCache.INSTANCE.cacheFile, StandardCopyOption.REPLACE_EXISTING);
                Oneenoughitem.LOGGER.debug("Editor cache saved successfully to: {}", (Object)EditorCache.INSTANCE.cacheFile);
            }
            catch (IOException e) {
                Oneenoughitem.LOGGER.error("Failed to replace editor cache file: {}", (Object)EditorCache.INSTANCE.cacheFile, (Object)e);
            }
        });
    }

    public static CacheData loadCache() {
        return INSTANCE.withReadLock(() -> {
            if (!Files.exists(EditorCache.INSTANCE.cacheFile, new LinkOption[0])) {
                Oneenoughitem.LOGGER.debug("Editor cache file not found: {}", (Object)EditorCache.INSTANCE.cacheFile);
                return null;
            }
            try (DataInputStream dis = new DataInputStream(new BufferedInputStream(Files.newInputStream(EditorCache.INSTANCE.cacheFile, new OpenOption[0])));){
                int version = dis.readInt();
                if (version != EditorCache.INSTANCE.cacheVersion) {
                    Oneenoughitem.LOGGER.warn("Editor cache version mismatch (expected {}, found {}), ignoring cache", (Object)EditorCache.INSTANCE.cacheVersion, (Object)version);
                    CacheData cacheData = null;
                    return cacheData;
                }
                Set<String> matchItems = EditorCache.readStringSet(dis);
                Set<String> matchTags = EditorCache.readStringSet(dis);
                String resultItem = EditorCache.emptyToNull(dis.readUTF());
                String resultTag = EditorCache.emptyToNull(dis.readUTF());
                String fileName = EditorCache.emptyToNull(dis.readUTF());
                Oneenoughitem.LOGGER.debug("Editor cache loaded successfully from: {}", (Object)EditorCache.INSTANCE.cacheFile);
                CacheData cacheData = new CacheData(matchItems, matchTags, resultItem, resultTag, fileName);
                return cacheData;
            }
            catch (IOException e) {
                Oneenoughitem.LOGGER.error("Failed to load editor cache from: {}", (Object)EditorCache.INSTANCE.cacheFile, (Object)e);
                return null;
            }
        });
    }

    public static void clearCache() {
        INSTANCE.clearCacheFile();
    }

    @Override
    public Path getCacheFilePath() {
        return EditorCache.INSTANCE.cacheFile;
    }

    private static void writeStringSet(DataOutputStream dos, Set<String> stringSet) throws IOException {
        Set<String> nonNullSet = stringSet != null ? stringSet : Collections.emptySet();
        dos.writeInt(nonNullSet.size());
        for (String s : nonNullSet) {
            if (s == null || s.isEmpty()) continue;
            dos.writeUTF(s);
        }
    }

    private static Set<String> readStringSet(DataInputStream dis) throws IOException {
        int count = dis.readInt();
        HashSet<String> result = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            String str = dis.readUTF();
            if (str.isEmpty()) continue;
            result.add(str);
        }
        return result;
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    private static String emptyToNull(String s) {
        return s.isEmpty() ? null : s;
    }

    private static void logSaveError(IOException e) {
        Oneenoughitem.LOGGER.error("Failed to save editor cache to: {}", (Object)EditorCache.INSTANCE.cacheFile, (Object)e);
    }

    public record CacheData(Set<String> matchItems, Set<String> matchTags, String resultItem, String resultTag, String fileName) {
    }
}

