/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.AbstractGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.components.TagListWidget;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class BaseTagSelectionScreen
extends Screen {
    protected final ReplacementEditorScreen parent;
    protected final boolean isForMatch;
    protected EditBox searchBox;
    protected Button backButton;
    protected TagListWidget tagList;
    protected List<ResourceLocation> allTags;
    protected List<ResourceLocation> filteredTags;
    protected final Set<ResourceLocation> selectedTags = new HashSet<ResourceLocation>();
    protected Button confirmSelectionButton;
    protected Button clearSelectionButton;
    private int lastSearchLength = 0;

    protected BaseTagSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch, Component title) {
        super(title);
        this.parent = parent;
        this.isForMatch = isForMatch;
        this.allTags = new ArrayList<ResourceLocation>();
        this.filteredTags = new ArrayList<ResourceLocation>();
    }

    protected abstract List<ResourceLocation> loadAllTags();

    private void onSelectTag(ResourceLocation tagId) {
        String tagStr;
        String string = tagStr = tagId != null ? tagId.toString() : null;
        if (tagStr == null) {
            return;
        }
        AbstractGlobalReplacementCache global = DomainRegistry.current().globalCache();
        if (global.isTagUsedAsResult(tagStr) || global.isTagReplaced(tagStr)) {
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchTag(tagId);
        } else {
            this.parent.setResultTag(tagId);
        }
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 80, 15, 160, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.search"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.tagList = new TagListWidget(this.f_96541_, this.f_96543_ - 40, this.f_96544_ - 100, 40, 22, this::handleTagClick);
        this.tagList.m_93507_(20);
        this.tagList.setSelectedTags(this.selectedTags);
        this.m_142416_((GuiEventListener)this.tagList);
        if (this.isForMatch) {
            int buttonY = this.f_96544_ - 50;
            int totalWidth = 290;
            int startX = centerX - totalWidth / 2;
            this.confirmSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_selected"), btn -> this.confirmSelectedTags(), startX, buttonY, 100, 18);
            this.m_142416_((GuiEventListener)this.confirmSelectionButton);
            this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), startX + 110, buttonY, 80, 18);
            this.m_142416_((GuiEventListener)this.backButton);
            this.clearSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_selected"), btn -> {
                this.selectedTags.clear();
                this.updateTagList();
                this.updateConfirmButtonsVisibility();
            }, startX + 200, buttonY, 100, 18);
            this.m_142416_((GuiEventListener)this.clearSelectionButton);
            this.updateConfirmButtonsVisibility();
        } else {
            this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), centerX - 40, this.f_96544_ - 50, 80, 18);
            this.m_142416_((GuiEventListener)this.backButton);
        }
        this.allTags = this.loadAllTags();
        this.filteredTags = new ArrayList<ResourceLocation>(this.allTags);
        this.updateTagList();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox.m_94155_().length() != this.getLastSearchLength()) {
            this.filterTags();
            this.updateTagList();
        }
    }

    private int getLastSearchLength() {
        int current = this.lastSearchLength;
        this.lastSearchLength = this.searchBox.m_94155_().length();
        return current;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int panelX = 20;
        int panelY = 40;
        int panelW = this.f_96543_ - 40;
        int panelH = this.f_96544_ - 100;
        GuiUtils.drawPanelBackground(graphics, panelX, panelY, panelW, panelH);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        String tagCount = this.filteredTags.size() + " tags";
        graphics.m_280488_(this.f_96547_, tagCount, 10, this.f_96544_ - 30, 0xFFFFFF);
    }

    protected void filterTags() {
        String search = this.searchBox.m_94155_().toLowerCase();
        this.filteredTags = search.isEmpty() ? new ArrayList<ResourceLocation>(this.allTags) : this.allTags.stream().filter(tag -> tag.toString().toLowerCase().contains(search)).toList();
    }

    protected void updateTagList() {
        this.tagList.setTags(this.filteredTags);
    }

    private void handleTagClick(ResourceLocation tagId) {
        if (this.isForMatch && BaseTagSelectionScreen.m_96637_()) {
            if (this.selectedTags.contains(tagId)) {
                this.selectedTags.remove(tagId);
            } else {
                this.selectedTags.add(tagId);
            }
            this.updateTagList();
            this.updateConfirmButtonsVisibility();
            return;
        }
        this.onSelectTag(tagId);
        this.m_7379_();
    }

    protected void confirmSelectedTags() {
        if (!this.isForMatch || this.selectedTags.isEmpty()) {
            return;
        }
        for (ResourceLocation tagId : new ArrayList<ResourceLocation>(this.selectedTags)) {
            this.onSelectTag(tagId);
        }
        this.selectedTags.clear();
        this.updateTagList();
        this.updateConfirmButtonsVisibility();
        this.m_7379_();
    }

    protected void updateConfirmButtonsVisibility() {
        boolean hasSelection;
        if (!this.isForMatch) {
            return;
        }
        boolean bl = hasSelection = !this.selectedTags.isEmpty();
        if (this.confirmSelectionButton != null) {
            this.confirmSelectionButton.f_93623_ = hasSelection;
        }
        if (this.clearSelectionButton != null) {
            this.clearSelectionButton.f_93623_ = hasSelection;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }
}

