/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.client.TooltipUtils;
import alexthw.ars_elemental.client.armor.ElementalArmorModel;
import alexthw.ars_elemental.client.armor.ElementalArmorRenderer;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class ElementalArmor
extends AnimatedMagicArmor
implements IElementalArmor {
    final SpellSchool element;
    EquipmentSlot[] OrderedSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ElementalArmor(ArmorItem.Type slot, SpellSchool element, Item.Properties builder) {
        super(IElementalArmor.schoolToMaterial(element), slot, new ElementalArmorModel("medium_armor_e").withEmptyAnim());
        this.element = element;
    }

    public int getMinTier() {
        return 2;
    }

    @Override
    public SpellSchool getSchool() {
        return this.element;
    }

    @Override
    public String getTier() {
        return "medium";
    }

    public int getManaDiscount(ItemStack i, Spell spell) {
        return Mth.m_14165_((double)this.getDiscount(spell.recipe));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        IPerkProvider perkProvider = PerkRegistry.getPerkProvider((Item)stack.m_41720_());
        if (perkProvider != null) {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{4}).m_130940_(ChatFormatting.GOLD));
            perkProvider.getPerkHolder((Object)stack).appendPerkTooltip(tooltip, (Object)stack);
        }
        TooltipUtils.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, world, tooltip, flags), "armor_set");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        Player player = ArsNouveau.proxy.getPlayer();
        if (player != null) {
            ArmorSet set = this.getArmorSetFromElement(this.element);
            ArrayList<MutableComponent> equippedList = new ArrayList<MutableComponent>();
            int equippedCounter = 0;
            for (EquipmentSlot slot : this.OrderedSlots) {
                Item armor = set.getArmorFromSlot(slot);
                MutableComponent cmp = Component.m_237113_((String)" - ").m_7220_(armor.m_7968_().m_41786_());
                if (this.hasArmorSetItem(player.m_6844_(slot), armor)) {
                    cmp.m_130940_(ChatFormatting.GREEN);
                    ++equippedCounter;
                } else {
                    cmp.m_130940_(ChatFormatting.GRAY);
                }
                equippedList.add(cmp);
            }
            list.add(this.getArmorSetTitle(set, equippedCounter));
            list.addAll(equippedList);
            this.addArmorSetDescription(set, list);
        }
    }

    private boolean hasArmorSetItem(ItemStack armor, Item armorFromSlot) {
        return armor.m_41720_() == armorFromSlot;
    }

    ArmorSet getArmorSetFromElement(SpellSchool element) {
        return switch (element.getId()) {
            case "air" -> ModItems.AIR_ARMOR;
            case "fire" -> ModItems.FIRE_ARMOR;
            case "water" -> ModItems.WATER_ARMOR;
            case "earth" -> ModItems.EARTH_ARMOR;
            default -> null;
        };
    }

    private Component getArmorSetTitle(ArmorSet set, int equipped) {
        return Component.m_237115_((String)set.getTranslationKey()).m_130946_(" (" + equipped + " / 4)").m_130940_(ChatFormatting.DARK_AQUA);
    }

    public void addArmorSetDescription(ArmorSet set, List<Component> list) {
        list.add((Component)Component.m_237115_((String)("ars_elemental.armor_set." + set.getName() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.m_266204_().m_266308_() == pEquipmentSlot) {
            UUID uuid = (UUID)f_265987_.get(this.m_266204_());
            IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (perkHolder != null) {
                attributes.put((Object)((Attribute)PerkAttributes.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "max_mana_armor", (double)((Integer)ConfigHandler.Common.ARMOR_MAX_MANA.get()).intValue(), AttributeModifier.Operation.ADDITION));
                attributes.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, "mana_regen_armor", (double)((Integer)ConfigHandler.Common.ARMOR_MANA_REGEN.get()).intValue(), AttributeModifier.Operation.ADDITION));
                for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                    IPerk perk = perkInstance.getPerk();
                    attributes.putAll(perk.getModifiers(this.m_266204_().m_266308_(), stack, perkInstance.getSlot().value));
                }
            }
        }
        return attributes.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ElementalArmorRenderer((GeoModel<AnimatedMagicArmor>)ElementalArmor.this.getArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return new ResourceLocation("ars_elemental", "textures/armor/" + this.getTier() + "_armor_" + this.getSchool().getId() + ".png").toString();
    }
}

