/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ItemMatchProperties {
    private final ItemStack itemStack;
    private boolean nbt;
    @Nullable
    private String itemTag;
    private int tagQuantity;
    private boolean reusable;

    public ItemMatchProperties(ItemStack itemStack) {
        this(itemStack, false, null, 1, false);
    }

    public ItemMatchProperties(ItemStack itemStack, boolean nbt, @Nullable String itemTag, int tagQuantity) {
        this(itemStack, nbt, itemTag, tagQuantity, false);
    }

    public ItemMatchProperties(ItemStack itemStack, boolean nbt, @Nullable String itemTag, int tagQuantity, boolean reusable) {
        this.itemStack = itemStack;
        this.nbt = nbt;
        this.itemTag = itemTag;
        this.tagQuantity = tagQuantity;
        this.reusable = reusable;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    @Nullable
    public String getItemTag() {
        return this.itemTag;
    }

    public void setItemTag(@Nullable String itemTag) {
        this.itemTag = itemTag;
    }

    public int getTagQuantity() {
        return this.tagQuantity;
    }

    public void setTagQuantity(int tagQuantity) {
        this.tagQuantity = tagQuantity;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }

    public boolean isValid() {
        return this.getItemTag() != null || !this.getItemStack().m_41619_();
    }

    public IPrototypedIngredientAlternatives<ItemStack, Integer> createPrototypedIngredient() {
        if (this.getItemTag() == null) {
            int flags = this.isNbt() ? 5 : 1;
            return new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)this.itemStack, (Object)flags)));
        }
        return new PrototypedIngredientAlternativesItemStackTag(Collections.singletonList(this.getItemTag()), Integer.valueOf(5), (long)this.getTagQuantity());
    }

    public static ItemMatchProperties fromPrototypedIngredient(IPrototypedIngredientAlternatives<ItemStack, Integer> prototypedIngredient, boolean reusable) {
        PrototypedIngredientAlternativesList prototypedList;
        Collection alternatives;
        IPrototypedIngredient prototype;
        ItemMatchProperties props = new ItemMatchProperties(ItemStack.f_41583_);
        if (prototypedIngredient instanceof PrototypedIngredientAlternativesItemStackTag) {
            PrototypedIngredientAlternativesItemStackTag prototypedTag = (PrototypedIngredientAlternativesItemStackTag)prototypedIngredient;
            prototypedTag.getKeys().stream().findFirst().ifPresent(props::setItemTag);
            props.setTagQuantity((int)prototypedTag.getQuantity());
        } else if (prototypedIngredient instanceof PrototypedIngredientAlternativesList && (prototype = (IPrototypedIngredient)(alternatives = (prototypedList = (PrototypedIngredientAlternativesList)prototypedIngredient).getAlternatives()).stream().findFirst().orElse(null)) != null) {
            props = new ItemMatchProperties((ItemStack)prototype.getPrototype());
            props.setNbt(IngredientComponent.ITEMSTACK.getMatcher().hasCondition((Object)((Integer)prototype.getCondition()), (Object)4));
        }
        props.setReusable(reusable);
        return props;
    }

    static {
        PacketCodec.addCodedAction(ItemMatchProperties.class, (PacketCodec.ICodecAction)new PacketCodec.ICodecAction(){

            public void encode(Object o, FriendlyByteBuf packetBuffer) {
                ItemMatchProperties props = (ItemMatchProperties)o;
                PacketCodec.getAction(ItemStack.class).encode((Object)props.itemStack, packetBuffer);
                packetBuffer.writeBoolean(props.nbt);
                packetBuffer.m_130070_(props.itemTag != null ? props.itemTag : "");
                packetBuffer.writeInt(props.tagQuantity);
                packetBuffer.writeBoolean(props.reusable);
            }

            public Object decode(FriendlyByteBuf packetBuffer) {
                ItemStack itemStack = (ItemStack)PacketCodec.getAction(ItemStack.class).decode(packetBuffer);
                boolean nbt = packetBuffer.readBoolean();
                String itemTag = packetBuffer.m_130136_(Short.MAX_VALUE);
                int tagQuantity = packetBuffer.readInt();
                boolean reusable = packetBuffer.readBoolean();
                return new ItemMatchProperties(itemStack, nbt, itemTag.isEmpty() ? null : itemTag, tagQuantity, reusable);
            }
        });
    }
}

