/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block", ValueBlock.class);
    }

    public static MutableComponent getBlockkDisplayNameSafe(BlockState blockState) {
        return Component.m_237115_((String)blockState.m_60734_().m_7705_());
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.f_50016_.m_49966_());
    }

    @Override
    public MutableComponent toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
            if (!itemStack.m_41619_()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return Component.m_237113_((String)"");
    }

    @Override
    public Tag serialize(ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundTag();
        }
        return BlockHelpers.serializeBlockState((BlockState)((BlockState)value.getRawValue().get()));
    }

    @Override
    public ValueBlock deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value.m_7060_() == 0 || value.m_7060_() == 10 && ((CompoundTag)value).m_128456_()) {
            return ValueBlock.of(Blocks.f_50016_.m_49966_());
        }
        return ValueBlock.of(BlockHelpers.deserializeBlockState(valueDeseralizationContext.holderGetter(), (CompoundTag)((CompoundTag)value)));
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                if (!itemStack.m_41619_() && !(itemStack.m_41720_() instanceof BlockItem)) {
                    return Component.m_237115_((String)"valuetype.integrateddynamics.error.block.no_block");
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.m_41619_() ? Blocks.f_50016_.m_49966_() : BlockHelpers.getBlockStateFromItemStack((ItemStack)itemStack));
            }

            @Override
            public ItemStack getValueAsItemStack(ValueBlock value) {
                return value.getRawValue().map(BlockHelpers::getItemStackFromBlockState).orElse(ItemStack.f_41583_);
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            return ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString();
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<BlockState> {
        private ValueBlock(BlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(BlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(BlockState a, BlockState b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

