/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.OverslimeModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class OvergrowthModule
implements ModifierModule,
InventoryTickModifierHook,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.INVENTORY_TICK);
    protected static final LoadableField<LevelingValue, OvergrowthModule> CHANCE_FIELD = LevelingValue.LOADABLE.requiredField("chance", OvergrowthModule::chance);
    public static final RecordLoadable<OvergrowthModule> LOADER = RecordLoadable.create(CHANCE_FIELD, ModifierCondition.TOOL_FIELD, OvergrowthModule::new);
    private final LevelingValue chance;
    private final ModifierCondition<IToolStackView> condition;

    public OvergrowthModule(LevelingValue chance) {
        this(chance, ModifierCondition.ANY_TOOL);
    }

    public RecordLoadable<? extends OvergrowthModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    protected CapacityBarHook getBar(ModifierEntry modifier) {
        return OverslimeModule.INSTANCE;
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        CapacityBarHook bar;
        if (!world.f_46443_ && holder.f_19797_ % 20 == 0 && holder.m_21211_() != stack && this.condition.matches(tool, modifier) && (bar = this.getBar(modifier)).getAmount(tool) < bar.getCapacity(tool, modifier) && Modifier.RANDOM.nextFloat() < this.chance.compute(modifier.getEffectiveLevel())) {
            bar.addAmount(tool, modifier, 1);
        }
    }

    public LevelingValue chance() {
        return this.chance;
    }

    @Override
    public ModifierCondition<IToolStackView> condition() {
        return this.condition;
    }

    public OvergrowthModule(LevelingValue chance, ModifierCondition<IToolStackView> condition) {
        this.chance = chance;
        this.condition = condition;
    }
}

