/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.sling;

import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingAngleModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingForceModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.tools.TinkerToolActions;
import slimeknights.tconstruct.tools.modifiers.ability.sling.SlingModifier;

public class SpringingModifier
extends SlingModifier {
    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK) {
            GeneralInteractionModifierHook.startUsingWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        Player player;
        Level level = entity.m_9236_();
        if (entity instanceof Player && !(player = (Player)entity).m_21255_()) {
            player.m_36399_(0.2f);
            float charge = this.getCharge(tool, modifier, timeLeft);
            if (charge > 0.0f) {
                float multiplier = charge * 1.05f;
                float force = SlingForceModifierHook.modifySlingForce(tool, entity, entity, modifier, this.getPower(tool, (LivingEntity)player) * multiplier, multiplier);
                if (force > 0.0f) {
                    Vec3 look = player.m_20154_().m_82520_(0.0, Math.max(0.0, 0.5 - (double)force * 0.1), 0.0).m_82541_();
                    RandomSource random = player.m_217043_();
                    float inaccuracy = ModifierUtil.getInaccuracy(tool, (LivingEntity)player) * 0.0075f;
                    Vec3 angle = SlingAngleModifierHook.modifySlingAngle(tool, entity, entity, modifier, force, multiplier, new Vec3(look.f_82479_ + random.m_188583_() * (double)inaccuracy, (look.f_82480_ + random.m_188583_() * (double)inaccuracy) / 2.0, look.f_82481_ + random.m_188583_() * (double)inaccuracy));
                    player.m_5997_((double)force * angle.f_82479_, (double)force * angle.f_82480_, (double)force * angle.f_82481_);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, (double)1.3f, 0.0));
                    }
                    SlingLaunchModifierHook.afterSlingLaunch(tool, entity, entity, modifier, force, multiplier, angle);
                    SlimeBounceHandler.addBounceHandler((LivingEntity)player);
                    if (!level.f_46443_) {
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.SLIME_SLING.getSound(), player.m_5720_(), 1.0f, 1.0f);
                        player.m_36399_(0.2f);
                        player.m_36335_().m_41524_(tool.getItem(), 3);
                        ToolDamageUtil.damageAnimated(tool, 1, entity);
                    }
                    if (ModifierUtil.canPerformAction(tool, TinkerToolActions.DRILL_ATTACK)) {
                        player.m_204079_(20);
                    }
                    return;
                }
            }
        }
        if (SpringingModifier.isActive(tool, modifier, activeModifier)) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.SLIME_SLING.getSound(), entity.m_5720_(), 1.0f, 0.5f);
        }
    }
}

