/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.loot.AbstractLootModifierBuilder;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.DummyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootModifier
extends LootModifier {
    public static final Codec<ModifierLootModifier> CODEC = RecordCodecBuilder.create(inst -> ModifierLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ModifierLootModifier::new));

    protected ModifierLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public static AbstractLootModifierBuilder.GenericLootModifierBuilder<ModifierLootModifier> builder() {
        return new AbstractLootModifierBuilder.GenericLootModifierBuilder(ModifierLootModifier::new);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ToolStack tool;
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (stack == null) {
            Object object = context.m_78953_(LootContextParams.f_81459_);
            if (object instanceof Projectile) {
                Projectile projectile = (Projectile)object;
                ModifierNBT modifiers = EntityModifierCapability.getOrEmpty((Entity)projectile);
                if (!modifiers.isEmpty()) {
                    ModDataNBT persistentData = (ModDataNBT)projectile.getCapability(PersistentDataCapability.CAPABILITY).orElseGet(ModDataNBT::new);
                    DummyToolStack dummyTool = new DummyToolStack(Items.f_41852_, modifiers, persistentData);
                    for (ModifierEntry entry : modifiers) {
                        entry.getHook(ModifierHooks.PROCESS_LOOT).processLoot(dummyTool, entry, (List<ItemStack>)generatedLoot, context);
                    }
                }
                return generatedLoot;
            }
            object = context.m_78953_(LootContextParams.f_81458_);
            if (object instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)object;
                stack = living.m_6844_(ModifierLootingHandler.getLootingSlot(living));
            }
        }
        if (stack != null && stack.m_204117_(TinkerTags.Items.LOOT_CAPABLE_TOOL) && !(tool = ToolStack.from(stack)).isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.PROCESS_LOOT).processLoot(tool, entry, (List<ItemStack>)generatedLoot, context);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

