/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tables.client.inventory.PartBuilderScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;

public class PartInfoPanelScreen
extends InfoPanelScreen<PartBuilderScreen, PartBuilderContainerMenu> {
    private static final String COST_KEY = TConstruct.makeTranslationKey("gui", "part_builder.cost");
    private static final String MATERIAL_VALUE_KEY = TConstruct.makeTranslationKey("gui", "part_builder.material_value");
    private Component patternCost = Component.m_237119_();
    private Component materialValue = Component.m_237119_();

    public PartInfoPanelScreen(PartBuilderScreen parent, PartBuilderContainerMenu container, Inventory playerInventory, Component title) {
        super(parent, container, playerInventory, title);
    }

    public void clearPatternCost() {
        this.patternCost = Component.m_237119_();
        this.updateSliderParameters();
    }

    public void setPatternCost(int cost) {
        this.patternCost = Component.m_237110_((String)COST_KEY, (Object[])new Object[]{cost}).m_130940_(ChatFormatting.GOLD);
        this.updateSliderParameters();
    }

    private boolean hasPatternCost() {
        return this.patternCost != null && this.patternCost.m_214077_() != ComponentContents.f_237124_;
    }

    public void setMaterialValue(Component value) {
        this.materialValue = Component.m_237110_((String)MATERIAL_VALUE_KEY, (Object[])new Object[]{value}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0x7FFFFF)));
        this.updateSliderParameters();
    }

    public void clearMaterialValue() {
        this.materialValue = Component.m_237119_();
        this.updateSliderParameters();
    }

    private boolean hasMaterialValue() {
        return this.materialValue != null && this.materialValue.m_214077_() != ComponentContents.f_237124_;
    }

    @Override
    public int calcNeededHeight() {
        int neededHeight = 0;
        if (!this.hasInitialized()) {
            return this.f_96544_;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            neededHeight += scaledFontHeight + 3;
        }
        if (this.hasPatternCost()) {
            neededHeight += scaledFontHeight + 3;
        }
        if (this.hasMaterialValue()) {
            neededHeight += scaledFontHeight + 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)scaledFontHeight + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    @Override
    protected float getTooltipStart(float y) {
        y = super.getTooltipStart(y);
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasPatternCost()) {
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasMaterialValue()) {
            y += (float)(scaledFontHeight + 3);
        }
        return y;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x2;
        this.border.draw(graphics);
        BACKGROUND.drawScaled(graphics, this.f_97735_ + 4, this.f_97736_ + 4, this.f_97726_ - 8, this.f_97727_ - 8);
        float y = 5 + this.f_97736_;
        float x = 5 + this.f_97735_;
        int color = -986896;
        if (this.hasTooltips()) {
            graphics.drawString(this.f_96547_, "?", (float)(this.guiRight() - this.border.w) - (float)this.f_96547_.m_92895_("?") / 2.0f, (float)(this.f_97736_ + 5), -10526881, false);
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            x2 = this.f_97726_ / 2;
            graphics.drawString(this.f_96547_, this.caption.m_7532_(), (float)this.f_97735_ + (float)(x2 -= this.f_96547_.m_92852_((FormattedText)this.caption) / 2), y, color, true);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasPatternCost()) {
            x2 = this.f_97726_ / 2;
            graphics.drawString(this.f_96547_, this.patternCost.m_7532_(), (float)this.f_97735_ + (float)(x2 -= this.f_96547_.m_92852_((FormattedText)this.patternCost) / 2), y, color, true);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.hasMaterialValue()) {
            x2 = this.f_97726_ / 2;
            graphics.drawString(this.f_96547_, this.materialValue.m_7532_(), (float)this.f_97735_ + (float)(x2 -= this.f_96547_.m_92852_((FormattedText)this.materialValue) / 2), y, color, true);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        Objects.requireNonNull(this.f_96547_);
        float textHeight = 9.0f + 0.5f;
        float lowerBound = (float)(this.f_97736_ + this.f_97727_ - 5) / this.textScale;
        PoseStack matrices = graphics.m_280168_();
        matrices.m_85836_();
        matrices.m_85841_(this.textScale, this.textScale, 1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<FormattedCharSequence> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            FormattedCharSequence line = iter.next();
            graphics.drawString(this.f_96547_, line, x, y, color, true);
            y += textHeight;
        }
        matrices.m_85849_();
        this.slider.update(mouseX, mouseY);
        this.slider.draw(graphics);
    }
}

