/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public enum ModifierTagSource implements TagSource<Modifier>
{
    INSTANCE;


    public ResourceKey<? extends Registry<Modifier>> key() {
        return ModifierManager.REGISTRY_KEY;
    }

    public String folder() {
        return "tinkering/tags/modifiers";
    }

    public boolean hasTag(TagKey<Modifier> tag) {
        return ModifierManager.getTagOrNull(tag) != null;
    }

    public Stream<TagKey<Modifier>> tagKeys() {
        return ModifierManager.getAllTags().map(Map.Entry::getKey);
    }

    @Nullable
    public List<Modifier> valuesInTag(TagKey<Modifier> tag) {
        return ModifierManager.getTagOrNull(tag);
    }

    @Nullable
    public List<ResourceLocation> keysInTag(TagKey<Modifier> tag) {
        List<Modifier> entries = ModifierManager.getTagOrNull(tag);
        if (entries == null) {
            return null;
        }
        return entries.stream().map(Modifier::getId).collect(Collectors.toList());
    }

    @Nullable
    public Modifier getValue(ResourceLocation key) {
        ModifierId id = new ModifierId(key);
        if (ModifierManager.INSTANCE.contains(id)) {
            return ModifierManager.INSTANCE.get(id);
        }
        return null;
    }

    public Stream<TagKey<Modifier>> tagsFor(Modifier modifier) {
        return ModifierManager.getTagKeys(modifier.getId());
    }

    public Stream<ResourceLocation> valueKeys() {
        return ModifierManager.INSTANCE.getAllLocations();
    }
}

