/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;

public record MaterialTagSource(MaterialManager manager) implements TagSource<IMaterial>
{
    public ResourceKey<? extends Registry<IMaterial>> key() {
        return MaterialManager.REGISTRY_KEY;
    }

    public String folder() {
        return "tinkering/tags/materials";
    }

    public boolean hasTag(TagKey<IMaterial> tag) {
        return this.manager.getTagOrNull(tag) != null;
    }

    public Stream<TagKey<IMaterial>> tagKeys() {
        return this.manager.getAllTags().map(Map.Entry::getKey);
    }

    @Nullable
    public List<IMaterial> valuesInTag(TagKey<IMaterial> tag) {
        return this.manager.getTagOrNull(tag);
    }

    @Nullable
    public List<ResourceLocation> keysInTag(TagKey<IMaterial> tag) {
        List<IMaterial> entries = this.manager.getTagOrNull(tag);
        if (entries == null) {
            return null;
        }
        return entries.stream().map(IMaterial::getIdentifier).collect(Collectors.toList());
    }

    @Nullable
    public IMaterial getValue(ResourceLocation key) {
        return this.manager.getMaterial(new MaterialId(key)).orElse(null);
    }

    public Stream<TagKey<IMaterial>> tagsFor(IMaterial material) {
        return this.manager.getTagKeys(material.getIdentifier());
    }

    public Stream<ResourceLocation> valueKeys() {
        return this.manager.getAllMaterials().stream().map(IMaterial::getIdentifier);
    }
}

