/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

public class SlotIngredientHelper
implements IIngredientHelper<SlotType.SlotCount> {
    private static final Component SLOTLESS = TConstruct.makeTranslation("stat", "slot.prefix.slotless");

    private static String getName(@Nullable SlotType.SlotCount slots) {
        if (slots == null || slots.count() <= 0) {
            return "slotless";
        }
        return slots.type().getName();
    }

    public IIngredientType<SlotType.SlotCount> getIngredientType() {
        return TConstructJEIConstants.SLOT_TYPE;
    }

    public String getDisplayName(SlotType.SlotCount slots) {
        if (slots.count() <= 0) {
            return SLOTLESS.getString();
        }
        return Component.m_237115_((String)slots.type().getPrefix()).getString() + slots.count();
    }

    public String getUniqueId(SlotType.SlotCount slots, UidContext context) {
        return SlotIngredientHelper.getName(slots);
    }

    public ResourceLocation getResourceLocation(SlotType.SlotCount slots) {
        return TConstruct.getResource(SlotIngredientHelper.getName(slots));
    }

    public SlotType.SlotCount copyIngredient(SlotType.SlotCount slots) {
        return slots;
    }

    public String getErrorInfo(@Nullable SlotType.SlotCount slots) {
        return SlotIngredientHelper.getName(slots);
    }

    public ItemStack getCheatItemStack(SlotType.SlotCount slots) {
        if (slots.count() <= 0) {
            return ItemStack.f_41583_;
        }
        return CreativeSlotItem.withSlot(new ItemStack(TinkerModifiers.creativeSlotItem, slots.count()), slots.type());
    }

    public boolean isValidIngredient(SlotType.SlotCount slots) {
        return slots.count() >= 0;
    }

    public long getAmount(SlotType.SlotCount slots) {
        return slots.count();
    }

    public SlotType.SlotCount copyWithAmount(SlotType.SlotCount slots, long amount) {
        return new SlotType.SlotCount(slots.type(), (int)amount);
    }

    public SlotType.SlotCount normalizeIngredient(SlotType.SlotCount slots) {
        if (slots.count() <= 0) {
            return new SlotType.SlotCount(SlotType.UPGRADE, 0);
        }
        if (slots.count() == 1) {
            return slots;
        }
        return new SlotType.SlotCount(slots.type(), 1);
    }

    public Iterable<Integer> getColors(SlotType.SlotCount slots) {
        if (slots.count() <= 0) {
            return List.of(Integer.valueOf(-16777216));
        }
        return List.of(Integer.valueOf(0xFF000000 | slots.type().getColor().m_131265_()));
    }
}

