/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;

public class DefaultEntityMeltingRecipe
extends EntityMeltingRecipe {
    private final Lazy<EntityIngredient> entities = Lazy.of(() -> DefaultEntityMeltingRecipe.getEntityList(recipes));

    private static EntityIngredient getEntityList(List<EntityMeltingRecipe> recipes) {
        LinkedHashSet<EntityType> unusedTypes = new LinkedHashSet<EntityType>();
        block0: for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            if (type.m_204039_(TinkerTags.EntityTypes.MELTING_HIDE) || type.m_20674_() == MobCategory.MISC && !type.m_204039_(TinkerTags.EntityTypes.MELTING_SHOW)) continue;
            for (EntityMeltingRecipe recipe : recipes) {
                if (!recipe.matches(type)) continue;
                continue block0;
            }
            unusedTypes.add(type);
        }
        return EntityIngredient.of(unusedTypes);
    }

    public DefaultEntityMeltingRecipe(List<EntityMeltingRecipe> recipes) {
        super(TConstruct.getResource("__default"), EntityIngredient.EMPTY, FluidOutput.fromStack((FluidStack)EntityMeltingModule.getDefaultFluid()), 2);
    }

    @Override
    public EntityIngredient getIngredient() {
        return (EntityIngredient)this.entities.get();
    }
}

