/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RestrictedCompoundTag {
    private final CompoundTag tag;
    private final Set<String> restrictedKeys;

    public boolean contains(String name, int type) {
        return !this.restrictedKeys.contains(name) && this.tag.m_128425_(name, type);
    }

    protected <T> T get(String name, BiFunction<CompoundTag, String, T> function, T defaultValue) {
        if (this.restrictedKeys.contains(name)) {
            return defaultValue;
        }
        return function.apply(this.tag, name);
    }

    @Nullable
    public Tag get(String name) {
        return this.get(name, CompoundTag::m_128423_, null);
    }

    public int getInt(String name) {
        return this.get(name, CompoundTag::m_128451_, 0);
    }

    public boolean getBoolean(String name) {
        return this.get(name, CompoundTag::m_128471_, false);
    }

    public float getFloat(String name) {
        return this.get(name, CompoundTag::m_128457_, Float.valueOf(0.0f)).floatValue();
    }

    public String getString(String name) {
        return this.get(name, CompoundTag::m_128461_, "");
    }

    public CompoundTag getCompound(String name) {
        if (this.restrictedKeys.contains(name)) {
            return new CompoundTag();
        }
        return this.tag.m_128469_(name);
    }

    public ListTag getList(String name, int type) {
        if (this.restrictedKeys.contains(name)) {
            return new ListTag();
        }
        return this.tag.m_128437_(name, type);
    }

    public void put(String name, Tag nbt) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128365_(name, nbt);
        }
    }

    public void putInt(String name, int value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128405_(name, value);
        }
    }

    public void putBoolean(String name, boolean value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128379_(name, value);
        }
    }

    public void putFloat(String name, float value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128350_(name, value);
        }
    }

    public void putString(String name, String value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128359_(name, value);
        }
    }

    public void remove(String name) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.m_128473_(name);
        }
    }

    public RestrictedCompoundTag(CompoundTag tag, Set<String> restrictedKeys) {
        this.tag = tag;
        this.restrictedKeys = restrictedKeys;
    }
}

