/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder.recycle;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.partbuilder.DisplayPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.PartBuilderToolRecycle;

public class PartBuilderRecycle
implements IPartBuilderRecipe,
IMultiRecipe<DisplayPartRecipe> {
    private static final Component RECYCLING = TConstruct.makeTranslation("recipe", "recycling");
    private static final List<Component> INSTRUCTIONS = List.of(TConstruct.makeTranslation("recipe", "recycling.info"));
    private static final List<Component> NOT_ENOUGH_DURABILITY = List.of(TConstruct.makeTranslation("recipe", "recycling.not_enough_durability").m_130940_(ChatFormatting.RED));
    private static final List<Component> NO_ENCHANTMENTS = List.of(TConstruct.makeTranslation("recipe", "recycling.no_enchantments").m_130940_(ChatFormatting.RED));
    public static final RecordLoadable<PartBuilderRecycle> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("tool", r -> r.tool), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("pattern", r -> r.pattern), (RecordField)Pattern.PARSER.mapWithValues((Loadable)ItemOutput.Loadable.REQUIRED_STACK).requiredField("results", r -> r.results), PartBuilderRecycle::new);
    private final ResourceLocation id;
    private final Ingredient tool;
    private final Ingredient pattern;
    private final Map<Pattern, ItemOutput> results;
    private final int resultCount;
    private List<DisplayPartRecipe> displayRecipes;

    public PartBuilderRecycle(ResourceLocation id, Ingredient tool, Ingredient pattern, Map<Pattern, ItemOutput> results) {
        this.id = id;
        this.tool = tool;
        this.pattern = pattern;
        this.results = results;
        this.resultCount = results.values().stream().mapToInt(ItemOutput::getCount).sum();
    }

    @Override
    public int getItemsUsed(IPartBuilderContainer inv) {
        return 1;
    }

    @Override
    public Pattern getPattern() {
        return MISSING;
    }

    @Override
    public Stream<Pattern> getPatterns(IPartBuilderContainer inv) {
        return this.results.keySet().stream();
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        return this.pattern.test(inv.getPatternStack()) && this.tool.test(inv.getStack());
    }

    private static int getAmount(ItemStack stack, int max) {
        int maxDamage = stack.m_41776_();
        if (maxDamage == 0) {
            return max;
        }
        return max * (maxDamage - stack.m_41773_()) / maxDamage;
    }

    public boolean matches(IPartBuilderContainer inv, Level level) {
        ItemStack stack = inv.getStack();
        return this.partialMatch(inv) && PartBuilderRecycle.getAmount(stack, this.resultCount) > 0 && stack.m_204117_(TinkerTags.Items.MODIFIABLE) ? !ModifierUtil.hasUpgrades(stack) : !stack.m_41793_();
    }

    @Override
    public ItemStack assemble(IPartBuilderContainer inv, RegistryAccess access, Pattern pattern) {
        int maxCount = PartBuilderRecycle.getAmount(inv.getStack(), this.resultCount);
        ItemOutput result = this.results.get((Object)pattern);
        if (result == null) {
            return ItemStack.f_41583_;
        }
        return result.get().m_255036_(Math.min(maxCount, result.getCount()));
    }

    @Override
    public ItemStack getLeftover(IPartBuilderContainer inv, Pattern pattern) {
        List<ItemOutput> alternatives;
        int maxCount = PartBuilderRecycle.getAmount(inv.getStack(), this.resultCount);
        ItemOutput result = this.results.get((Object)pattern);
        if (result != null) {
            maxCount -= result.getCount();
        }
        if (maxCount > 0 && this.results.size() > 1 && !(alternatives = this.results.entrySet().stream().filter(p -> p.getKey() != pattern).map(Map.Entry::getValue).toList()).isEmpty()) {
            ItemOutput chosen = alternatives.get(TConstruct.RANDOM.nextInt(alternatives.size()));
            return chosen.get().m_255036_(Math.min(maxCount, chosen.getCount()));
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.partBuilderDamageableRecycling.get();
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    @Override
    @Nullable
    public Component getTitle() {
        return RECYCLING;
    }

    @Override
    public List<Component> getText(IPartBuilderContainer inv) {
        ItemStack stack = inv.getStack();
        if (PartBuilderRecycle.getAmount(stack, this.resultCount) <= 0) {
            return NOT_ENOUGH_DURABILITY;
        }
        if (stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            if (ModifierUtil.hasUpgrades(stack)) {
                return PartBuilderToolRecycle.NO_MODIFIERS;
            }
        } else if (stack.m_41793_()) {
            return NO_ENCHANTMENTS;
        }
        return INSTRUCTIONS;
    }

    public List<DisplayPartRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> patternItems = List.of(this.pattern.m_43908_());
            List<ItemStack> toolItems = List.of(this.tool.m_43908_());
            this.displayRecipes = this.results.entrySet().stream().map(entry -> new DisplayPartRecipe(this.id, MaterialVariant.UNKNOWN, (Pattern)((Object)((Object)entry.getKey())), patternItems, 0, toolItems, List.of(((ItemOutput)entry.getValue()).get()))).toList();
        }
        return this.displayRecipes;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

