/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.DisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelIncrementalModifierRecipe
extends IncrementalModifierRecipe
implements IMultiRecipe<IDisplayModifierRecipe> {
    public static final RecordLoadable<MultilevelIncrementalModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)INPUT_FIELD, (RecordField)AMOUNT_FIELD, (RecordField)NEEDED_FIELD, (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEFTOVER_FIELD, (RecordField)ALLOW_CRYSTAL_FIELD, (RecordField)MultilevelModifierRecipe.LevelEntry.LOADABLE.list(1).requiredField("levels", r -> r.levels), (RecordField)CHECK_TRAIT_LEVEL_FIELD, MultilevelIncrementalModifierRecipe::new);
    private final List<MultilevelModifierRecipe.LevelEntry> levels;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    protected MultilevelIncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, int maxToolSize, ModifierId result, ItemOutput leftover, boolean allowCrystal, List<MultilevelModifierRecipe.LevelEntry> levels, boolean checkTraitLevel) {
        super(id, input, amountPerInput, neededPerLevel, toolRequirement, maxToolSize, result, levels.get(0).level(), levels.get(0).slots(), leftover, allowCrystal, checkTraitLevel);
        this.levels = levels;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        ModifierId modifier = this.result.getId();
        boolean crystal = this.matchesCrystal(inv);
        boolean isNewLevel = tool.getUpgrades().getEntry(modifier).getAmount(0) <= 0;
        SlotType.SlotCount slots = null;
        if (isNewLevel) {
            int newLevel = this.getNewLevel(tool);
            MultilevelModifierRecipe.LevelEntry levelEntry = MultilevelModifierRecipe.LevelEntry.find(this.levels, newLevel);
            if (levelEntry == null) {
                return MultilevelModifierRecipe.missingLevelError(this.levels, newLevel, this.result, this.checkTraitLevel);
            }
            slots = levelEntry.slots();
            Component requirements = MultilevelIncrementalModifierRecipe.checkSlots(tool, slots);
            if (requirements != null) {
                return RecipeResult.failure(requirements);
            }
        }
        tool = tool.copy();
        if (slots != null) {
            tool.getPersistentData().addSlots(slots.type(), -slots.count());
        }
        if (crystal) {
            tool.addModifier(modifier, 1);
        } else {
            tool.addModifierAmount(modifier, MultilevelIncrementalModifierRecipe.getAvailableAmount(inv, this.input, this.amountPerInput), this.neededPerLevel);
        }
        Component toolValidation = tool.tryValidate();
        if (toolValidation != null) {
            return RecipeResult.failure(toolValidation);
        }
        return this.success(tool, inv);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.multilevelIncrementalModifierSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            DisplayModifierRecipe.Builder builder = DisplayModifierRecipe.builder().id(this.m_6423_()).inputs(this.getInputs()).resultSlots(this.getResultSlots()).incremental().toolWithoutModifier(this.getToolWithoutModifier()).toolWithModifier(this.getToolWithModifier());
            this.displayRecipes = Streams.concat((Stream[])new Stream[]{Stream.of(this), this.levels.stream().skip(1L).map(levelEntry -> builder.copy().result(new ModifierEntry(this.result, levelEntry.level().min())).level(levelEntry.level()).slots(levelEntry.slots()).build())}).toList();
        }
        return this.displayRecipes;
    }
}

