/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ConditionalStatTooltip;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalStatModule(INumericToolStat<?> stat, IJsonPredicate<LivingEntity> holder, ConditionalStatFormula formula, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ConditionalStatModifierHook,
ConditionalStatTooltip,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.CONDITIONAL_STAT, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<ConditionalStatModule> LOADER = RecordLoadable.create((RecordField)ToolStats.NUMERIC_LOADER.requiredField("stat", ConditionalStatModule::stat), (RecordField)LivingEntityPredicate.LOADER.defaultField("entity", ConditionalStatModule::holder), (RecordField)ConditionalStatFormula.LOADER.directField(ConditionalStatModule::formula), ModifierCondition.TOOL_FIELD, ConditionalStatModule::new);

    @Override
    public boolean percent() {
        return this.formula.percent();
    }

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent() ? Integer.valueOf(75) : null;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (this.stat == stat && this.condition.matches(tool, modifier) && this.holder.matches((Object)living)) {
            return this.formula.apply(tool, modifier, living, baseValue, multiplier);
        }
        return baseValue;
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool, entry, (LivingEntity)player, 1.0f, tool.getMultiplier(this.stat));
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<ConditionalStatModule> getLoader() {
        return LOADER;
    }

    public static Builder stat(INumericToolStat<?> stat) {
        return new Builder(stat);
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalStatModule, ConditionalStatVariable> {
        private final INumericToolStat<?> stat;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;

        private Builder(INumericToolStat<?> stat) {
            super(ConditionalStatFormula.VARIABLES);
            this.stat = stat;
        }

        @Override
        protected ConditionalStatModule build(ModifierFormula formula) {
            return new ConditionalStatModule(this.stat, this.holder, new ConditionalStatFormula(formula, this.variables, this.percent), this.condition);
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }
    }
}

