/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.protection.ProtectionFormula;
import slimeknights.tconstruct.library.json.variable.protection.ProtectionVariable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.data.ModifierIds;

public record ProtectionModule(IJsonPredicate<DamageSource> source, IJsonPredicate<LivingEntity> entity, IJsonPredicate<LivingEntity> attacker, ProtectionFormula formula, ModifierCondition<IToolStackView> condition) implements ProtectionModifierHook,
TooltipModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROTECTION, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<ProtectionModule> LOADER = RecordLoadable.create((RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", ProtectionModule::source), (RecordField)LivingEntityPredicate.LOADER.defaultField("wearing_entity", ProtectionModule::entity), (RecordField)LivingEntityPredicate.LOADER.defaultField("attacker", ProtectionModule::attacker), (RecordField)ProtectionFormula.LOADER.directField(ProtectionModule::formula), ModifierCondition.TOOL_FIELD, ProtectionModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (this.condition.matches(tool, modifier) && this.source.matches((Object)source) && this.entity.matches((Object)context.getEntity()) && TinkerPredicate.matches(this.attacker, source.m_7639_())) {
            modifierValue = this.formula.apply(tool, modifier, context, context.getEntity(), slotType, source, modifierValue);
        }
        return modifierValue;
    }

    public static void addResistanceTooltip(IToolStackView tool, Modifier modifier, float amount, @Nullable Player player, List<Component> tooltip) {
        double cap = player != null ? ProtectionModifierHook.getProtectionCap((LivingEntity)player) : (double)Math.min(20.0f + (float)tool.getModifierLevel(ModifierIds.boundless) * 2.5f, 19.0f);
        tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)Util.PERCENT_BOOST_FORMAT.format(Math.min((double)amount, cap) / 25.0)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".resistance")))));
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float value;
        if (this.condition.matches(tool, modifier) && TinkerPredicate.matchesInTooltip(this.entity, (LivingEntity)player, tooltipKey) && Math.abs(value = this.formula.apply(tool, modifier, null, (LivingEntity)(tooltipKey == TooltipKey.SHIFT ? player : null), null, null, 0.0f)) > 0.25f) {
            ProtectionModule.addResistanceTooltip(tool, modifier.getModifier(), value, player, tooltip);
        }
    }

    public RecordLoadable<ProtectionModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ProtectionModule, ProtectionVariable> {
        private IJsonPredicate<DamageSource> source = DamageSourcePredicate.CAN_PROTECT;
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;

        private Builder() {
            super(ProtectionFormula.VARIABLES);
        }

        @SafeVarargs
        public final Builder sources(IJsonPredicate<DamageSource> ... sources) {
            return this.source((IJsonPredicate<DamageSource>)DamageSourcePredicate.and(sources));
        }

        @Override
        @Deprecated(forRemoval=true)
        public Builder percent() {
            return this;
        }

        @Override
        protected ProtectionModule build(ModifierFormula formula) {
            return new ProtectionModule(this.source, this.entity, this.attacker, new ProtectionFormula(formula, this.variables), this.condition);
        }

        public Builder source(IJsonPredicate<DamageSource> source) {
            this.source = source;
            return this;
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }
    }
}

