/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public enum InteractionSource {
    RIGHT_CLICK("interact_modifiers"),
    LEFT_CLICK("attack_modifiers"),
    ARMOR("unarmed_modifiers");

    public static InteractionSource[] HELD;
    private static final String ATTACK_FORMAT;
    private static final String INTERACT_FORMAT;
    private final ResourceLocation key;

    private InteractionSource(String key) {
        this.key = TConstruct.getResource(key);
    }

    public EquipmentSlot getSlot(InteractionHand hand) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RIGHT_CLICK -> {
                switch (hand) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case MAIN_HAND: {
                        yield EquipmentSlot.MAINHAND;
                    }
                    case OFF_HAND: 
                }
                yield EquipmentSlot.OFFHAND;
            }
            case LEFT_CLICK -> EquipmentSlot.MAINHAND;
            case ARMOR -> EquipmentSlot.CHEST;
        };
    }

    public static InteractionSource fromEquipmentSlot(EquipmentSlot slot) {
        return switch (slot.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.ARMOR -> ARMOR;
            case EquipmentSlot.Type.HAND -> RIGHT_CLICK;
        };
    }

    public static Component formatModifierName(IToolStackView tool, Modifier modifier, Component originalName) {
        if (ModifierSetWorktableRecipe.isInSet(tool.getPersistentData(), LEFT_CLICK.getKey(), modifier.getId())) {
            return modifier.applyStyle(Component.m_237110_((String)ATTACK_FORMAT, (Object[])new Object[]{originalName}));
        }
        if (ModifierSetWorktableRecipe.isInSet(tool.getPersistentData(), RIGHT_CLICK.getKey(), modifier.getId())) {
            return modifier.applyStyle(Component.m_237110_((String)INTERACT_FORMAT, (Object[])new Object[]{originalName}));
        }
        return originalName;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    static {
        HELD = new InteractionSource[]{RIGHT_CLICK, LEFT_CLICK};
        ATTACK_FORMAT = TConstruct.makeTranslationKey("modifier", "attack_toggled");
        INTERACT_FORMAT = TConstruct.makeTranslationKey("modifier", "interact_toggled");
    }
}

