/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;

public record DamageFluidEffect(float damage, @Nullable DamageTypePair damageType) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<DamageFluidEffect> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.requiredField("damage", e -> Float.valueOf(e.damage)), (RecordField)DamageTypePair.LOADER.nullableField("damage_type", DamageFluidEffect::damageType), DamageFluidEffect::new);

    @Override
    public RecordLoadable<DamageFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        float value = level.value();
        if (action.simulate()) {
            return value;
        }
        Projectile projectile = context.getProjectile();
        LivingEntity entity = context.getEntity();
        DamageSource source = this.damageType != null ? (projectile != null ? TinkerDamageTypes.source(context.getLevel().m_9598_(), this.damageType.ranged, (Entity)projectile, (Entity)entity) : TinkerDamageTypes.source(context.getLevel().m_9598_(), this.damageType.melee, (Entity)entity)) : context.createDamageSource();
        return ToolAttackUtil.attackEntitySecondary(source, this.damage * value, context.getTarget(), context.getLivingTarget(), true) ? value : 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        DamageType damageType;
        Object translationKey = FluidEffect.getTranslationKey(this.getLoader());
        if (this.damageType != null && (damageType = (DamageType)registryAccess.m_175515_(Registries.f_268580_).m_6246_(this.damageType.melee)) != null) {
            translationKey = (String)translationKey + "." + damageType.f_268677_();
        }
        return Component.m_237110_((String)translationKey, (Object[])new Object[]{Float.valueOf(this.damage)});
    }

    public record DamageTypePair(ResourceKey<DamageType> melee, ResourceKey<DamageType> ranged) {
        public static final RecordLoadable<DamageTypePair> LOADER = RecordLoadable.create((RecordField)Loadables.DAMAGE_TYPE_KEY.requiredField("melee", DamageTypePair::melee), (RecordField)Loadables.DAMAGE_TYPE_KEY.requiredField("ranged", DamageTypePair::ranged), DamageTypePair::new);

        public ResourceKey<DamageType>[] values() {
            return new ResourceKey[]{this.melee, this.ranged};
        }
    }
}

