/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ExtraTextureContext;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.tools.NestedOverrides;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialBlockModel
implements IUnbakedGeometry<MaterialBlockModel> {
    private static final ResourceLocation BAKE_LOCATION = Mantle.getResource((String)"material_block_dynamic");
    private static final Loadable<Set<String>> MATERIAL = StringLoadable.DEFAULT.set(-1);
    private static final Loadable<List<Set<String>>> PARTS = StringLoadable.DEFAULT.set(-2).list(1);
    public static final IGeometryLoader<MaterialBlockModel> LOADER = MaterialBlockModel::deserialize;
    private final SimpleBlockModel model;
    private final List<Set<String>> parts;
    private final ModelType type;

    public static MaterialBlockModel deserialize(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        if (json.has("retextured")) {
            return new MaterialBlockModel(model, List.of((Set)MATERIAL.getIfPresent(json, "retextured")), ModelType.ANVIL);
        }
        if (json.has("material")) {
            return new MaterialBlockModel(model, List.of((Set)MATERIAL.getIfPresent(json, "material")), ModelType.PART);
        }
        return new MaterialBlockModel(model, (List)PARTS.getIfPresent(json, "parts"), ModelType.TOOL);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.model.resolveParents(modelGetter, context);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bake(owner, baker, spriteGetter, transform, overrides, location);
        List<Set<String>> parts = this.parts.stream().map(part -> RetexturedModel.getAllRetextured((IGeometryBakingContext)owner, (SimpleBlockModel)this.model, (Set)part)).toList();
        if (this.type == ModelType.PART) {
            return new BakedPart(baked, owner, this.model, transform, parts.get(0));
        }
        if (this.type == ModelType.ANVIL) {
            return new BakedAnvil(baked, owner, this.model, transform, parts.get(0));
        }
        if (parts.size() == 1) {
            return new SimpleBakedTool(baked, owner, this.model, transform, parts.get(0));
        }
        boolean particleRetextured = parts.stream().anyMatch(set -> set.contains("particle"));
        return new BakedTool(baked, owner, this.model, transform, parts, particleRetextured);
    }

    public MaterialBlockModel(SimpleBlockModel model, List<Set<String>> parts, ModelType type) {
        this.model = model;
        this.parts = parts;
        this.type = type;
    }

    public static enum ModelType {
        TOOL,
        PART,
        ANVIL;

    }

    private static class BakedPart
    extends BakedSingleMaterial<MaterialVariantId> {
        private final ItemOverrides overrides;

        private BakedPart(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retexture) {
            super(original, owner, model, transform, retexture, ModelProperties.MATERIAL);
            this.overrides = new MaterialOverrides(original.m_7343_());
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        private class MaterialOverrides
        extends NestedOverrides {
            public MaterialOverrides(ItemOverrides nested) {
                super(nested);
            }

            @Override
            @Nullable
            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
                BakedModel resolved = super.m_173464_(originalModel, stack, world, entity, seed);
                if (resolved != originalModel) {
                    return resolved;
                }
                if (stack.m_41619_() || !stack.m_41782_()) {
                    return originalModel;
                }
                return BakedPart.this.getCachedModel(IMaterialItem.getMaterialFromStack(stack));
            }
        }
    }

    private static class BakedAnvil
    extends BakedSingleMaterial<MaterialVariantId> {
        private final Map<ResourceLocation, BakedModel> blockCache = new ConcurrentHashMap<ResourceLocation, BakedModel>();
        private final Function<ResourceLocation, BakedModel> blockBaker = this::bakeWithBlock;
        private final MaterialBlockOverrides overrides = new MaterialBlockOverrides();

        private BakedAnvil(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retexture) {
            super(original, owner, model, transform, retexture, ModelProperties.MATERIAL);
        }

        private BakedModel bakeWithBlock(ResourceLocation texture) {
            return this.model.bakeDynamic((IGeometryBakingContext)new RetexturedModel.RetexturedContext(this.owner, this.retexture, texture), this.transform);
        }

        @Override
        private BakedModel getCachedModel(Block block) {
            return this.blockCache.computeIfAbsent(ModelHelper.getParticleTexture((Block)block), this.blockBaker);
        }

        @Override
        public TextureAtlasSprite getParticleIcon(ModelData data) {
            Block block;
            if (this.particleRetextured && (block = (Block)data.get(RetexturedHelper.BLOCK_PROPERTY)) != null) {
                return this.getCachedModel(block).getParticleIcon(data);
            }
            return super.getParticleIcon(data);
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            Block block = (Block)extraData.get(RetexturedHelper.BLOCK_PROPERTY);
            if (block != null) {
                return this.getCachedModel(block).getQuads(state, side, rand, extraData, renderType);
            }
            return super.getQuads(state, side, rand, extraData, renderType);
        }

        public MaterialBlockOverrides getOverrides() {
            return this.overrides;
        }

        private class MaterialBlockOverrides
        extends ItemOverrides {
            private MaterialBlockOverrides() {
            }

            @Nullable
            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
                if (stack.m_41619_() || !stack.m_41782_()) {
                    return originalModel;
                }
                Block block = RetexturedHelper.getTexture((ItemStack)stack);
                if (block != Blocks.f_50016_) {
                    return BakedAnvil.this.getCachedModel(block);
                }
                return BakedAnvil.this.getCachedModel(IMaterialItem.getMaterialFromStack(stack));
            }
        }
    }

    private static class SimpleBakedTool
    extends BakedSingleMaterial<MaterialIdNBT> {
        private final ItemOverrides overrides;

        private SimpleBakedTool(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retexture) {
            super(original, owner, model, transform, retexture, ModelProperties.MATERIALS);
            this.overrides = new MaterialsOverrides(this, original.m_7343_());
        }

        @Override
        protected BakedModel getCachedModel(MaterialIdNBT materials) {
            return this.getCachedModel(materials.getMaterial(0));
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }
    }

    private static class BakedTool
    extends AbstractBaked<MaterialIdNBT, MaterialIdNBT> {
        private final Cache<MaterialIdNBT, BakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final List<Set<String>> parts;
        private final ItemOverrides overrides;

        private BakedTool(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, List<Set<String>> parts, boolean particleRetextured) {
            super(original, owner, model, transform, particleRetextured, ModelProperties.MATERIALS);
            this.parts = parts;
            this.overrides = new MaterialsOverrides(this, original.m_7343_());
        }

        @Override
        protected void fetchMaterials(MaterialIdNBT materials, Function<Material, TextureAtlasSprite> spriteGetter, Map<String, Material> replacements, Map<String, MaterialRenderInfo.TintedSprite> tints) {
            for (int i = 0; i < this.parts.size(); ++i) {
                this.fetchMaterial(materials.getMaterial(i), this.parts.get(i), spriteGetter, replacements, tints);
            }
        }

        @Override
        protected BakedModel getCachedModel(MaterialIdNBT materials) {
            if (!materials.getMaterials().isEmpty()) {
                try {
                    return (BakedModel)this.cache.get((Object)materials, () -> this.bakeWith(materials));
                }
                catch (ExecutionException e) {
                    TConstruct.LOG.error("Failed to get tool model from cache", (Throwable)e);
                }
            }
            return this.originalModel;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }
    }

    private static abstract class BakedSingleMaterial<P>
    extends AbstractBaked<MaterialVariantId, P> {
        private final Map<MaterialVariantId, BakedModel> cache = new ConcurrentHashMap<MaterialVariantId, BakedModel>();
        protected final Set<String> retexture;
        private final Function<MaterialVariantId, BakedModel> baker = this::bakeWith;

        private BakedSingleMaterial(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retexture, ModelProperty<P> property) {
            super(original, owner, model, transform, retexture.contains("particle"), property);
            this.retexture = retexture;
        }

        @Override
        public BakedModel getCachedModel(MaterialVariantId material) {
            if (IMaterial.UNKNOWN_ID.equals(material)) {
                return this.originalModel;
            }
            return this.cache.computeIfAbsent(material, this.baker);
        }

        @Override
        protected void fetchMaterials(MaterialVariantId materials, Function<Material, TextureAtlasSprite> spriteGetter, Map<String, Material> replacements, Map<String, MaterialRenderInfo.TintedSprite> tints) {
            this.fetchMaterial(materials, this.retexture, spriteGetter, replacements, tints);
        }
    }

    private static class MaterialsOverrides
    extends NestedOverrides {
        private final AbstractBaked<?, MaterialIdNBT> baked;

        public MaterialsOverrides(AbstractBaked<?, MaterialIdNBT> baked, ItemOverrides nested) {
            super(nested);
            this.baked = baked;
        }

        @Override
        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel resolved = super.m_173464_(originalModel, stack, world, entity, seed);
            if (resolved != originalModel) {
                return resolved;
            }
            if (stack.m_41619_() || !stack.m_41782_()) {
                return originalModel;
            }
            return this.baked.getCachedModel(MaterialIdNBT.from(stack));
        }
    }

    private static abstract class AbstractBaked<T, P>
    extends DynamicBakedWrapper<BakedModel> {
        protected final IGeometryBakingContext owner;
        protected final SimpleBlockModel model;
        protected final ModelState transform;
        protected final boolean particleRetextured;
        protected final ModelProperty<P> property;

        private AbstractBaked(BakedModel original, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, boolean particleRetextured, ModelProperty<P> property) {
            super(original);
            this.owner = owner;
            this.model = model;
            this.transform = transform;
            this.particleRetextured = particleRetextured;
            this.property = property;
        }

        protected abstract void fetchMaterials(T var1, Function<Material, TextureAtlasSprite> var2, Map<String, Material> var3, Map<String, MaterialRenderInfo.TintedSprite> var4);

        protected void fetchMaterial(MaterialVariantId material, Set<String> retextured, Function<Material, TextureAtlasSprite> spriteGetter, Map<String, Material> replacements, Map<String, MaterialRenderInfo.TintedSprite> tints) {
            Optional<MaterialRenderInfo> optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material);
            if (optional.isPresent()) {
                MaterialRenderInfo info = optional.get();
                HashMap<Material, MaterialRenderInfo.TintedSprite> seen = new HashMap<Material, MaterialRenderInfo.TintedSprite>();
                for (String name : retextured) {
                    Material texture = this.owner.getMaterial(name);
                    MaterialRenderInfo.TintedSprite tinted = (MaterialRenderInfo.TintedSprite)seen.get(texture);
                    if (tinted == null) {
                        tinted = info.getSprite(texture, spriteGetter);
                        seen.put(texture, tinted);
                    }
                    TextureAtlasSprite sprite = tinted.sprite();
                    replacements.put(name, new Material(sprite.m_247685_(), sprite.m_245424_().m_246162_()));
                    if (tinted.color() == -1 && tinted.emissivity() <= 0) continue;
                    tints.put("#" + name, tinted);
                }
            }
        }

        protected BakedModel bakeWith(T materials) {
            HashMap<String, Material> replacements = new HashMap<String, Material>();
            HashMap<String, MaterialRenderInfo.TintedSprite> tints = new HashMap<String, MaterialRenderInfo.TintedSprite>();
            Function<Material, TextureAtlasSprite> spriteGetter = Material::m_119204_;
            this.fetchMaterials(materials, spriteGetter, replacements, tints);
            if (replacements.isEmpty()) {
                return this.originalModel;
            }
            ExtraTextureContext retextureContext = new ExtraTextureContext(this.owner, replacements);
            if (tints.isEmpty()) {
                return this.model.bakeDynamic((IGeometryBakingContext)retextureContext, this.transform);
            }
            TextureAtlasSprite particle = spriteGetter.apply(this.owner.getMaterial("particle"));
            SimpleBakedModel.Builder builder = SimpleBlockModel.bakedBuilder((IGeometryBakingContext)this.owner, (ItemOverrides)this.originalModel.m_7343_()).m_119528_(particle);
            List elements = this.model.getElements();
            int size = elements.size();
            IQuadTransformer quadTransformer = SimpleBlockModel.applyTransform((ModelState)this.transform, (Transformation)this.owner.getRootTransform());
            Transformation transformation = this.transform.m_6189_();
            boolean uvlock = this.transform.m_7538_();
            for (int i = 0; i < size; ++i) {
                BlockElement part = (BlockElement)elements.get(i);
                MaterialRenderInfo.TintedSprite tint = null;
                for (BlockElementFace face : part.f_111310_.values()) {
                    MaterialRenderInfo.TintedSprite faceTint = (MaterialRenderInfo.TintedSprite)tints.get(face.f_111356_);
                    if (faceTint == null) continue;
                    tint = faceTint;
                    break;
                }
                if (tint != null) {
                    IQuadTransformer partTransformer = tint.color() == -1 ? quadTransformer : quadTransformer.andThen(ColoredBlockModel.applyColorQuadTransformer((int)tint.color()));
                    ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)retextureContext, (BlockElement)part, (int)tint.emissivity(), spriteGetter, (Transformation)transformation, (IQuadTransformer)partTransformer, (boolean)uvlock, (ResourceLocation)BAKE_LOCATION);
                    continue;
                }
                SimpleBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)retextureContext, (BlockElement)part, spriteGetter, (ModelState)this.transform, (IQuadTransformer)quadTransformer, (ResourceLocation)BAKE_LOCATION);
            }
            return builder.build(SimpleBlockModel.getRenderTypeGroup((IGeometryBakingContext)this.owner));
        }

        protected abstract BakedModel getCachedModel(P var1);

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            Object materials;
            if (this.particleRetextured && (materials = data.get(this.property)) != null) {
                return this.getCachedModel(materials).getParticleIcon(data);
            }
            return this.originalModel.getParticleIcon(data);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            Object materials = extraData.get(this.property);
            if (materials != null) {
                return this.getCachedModel(materials).getQuads(state, side, rand, extraData, renderType);
            }
            return this.originalModel.getQuads(state, side, rand, extraData, renderType);
        }
    }
}

