/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolActions;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;

public class TinkerItemProperties {
    private static final ResourceLocation BROKEN_ID = TConstruct.getResource("broken");
    private static final ItemPropertyFunction BROKEN = (stack, level, entity, seed) -> ToolDamageUtil.isBroken(stack) ? 1.0f : 0.0f;
    private static final ResourceLocation AMMO_ID = TConstruct.getResource("ammo");
    private static final ItemPropertyFunction AMMO = (stack, level, entity, seed) -> {
        CompoundTag ammo;
        CompoundTag persistentData;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !(persistentData = nbt.m_128469_("tic_persistent")).m_128456_() && !(ammo = persistentData.m_128469_(ModifiableCrossbowItem.KEY_CROSSBOW_AMMO.toString())).m_128456_()) {
            return ammo.m_128461_("id").equals(BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_42688_).toString()) ? 2.0f : 1.0f;
        }
        return 0.0f;
    };
    private static final ResourceLocation CHARGING_ID = TConstruct.getResource("charging");
    private static final ItemPropertyFunction CHARGING = (stack, level, holder, seed) -> {
        if (holder != null && holder.m_6117_() && holder.m_21211_() == stack) {
            UseAnim anim = stack.m_41780_();
            if (anim == UseAnim.BLOCK) {
                return ModifierUtil.checkPersistentPresent(stack, ModifiableLauncherItem.KEY_DRAWBACK_AMMO) ? 2.5f : 2.0f;
            }
            if (anim == UseAnim.SPEAR) {
                return 1.75f;
            }
            if (anim != UseAnim.EAT && anim != UseAnim.DRINK) {
                return ModifierUtil.checkPersistentPresent(stack, ModifiableLauncherItem.KEY_DRAWBACK_AMMO) ? 1.5f : 1.0f;
            }
        }
        return 0.0f;
    };
    private static final ResourceLocation CHARGE_ID = TConstruct.getResource("charge");
    private static final ItemPropertyFunction CHARGE = (stack, level, holder, seed) -> {
        if (holder == null || holder.m_21211_() != stack) {
            return 0.0f;
        }
        int drawtime = ModifierUtil.getPersistentInt(stack, GeneralInteractionModifierHook.KEY_DRAWTIME, -1);
        return drawtime == -1 ? 0.0f : (float)(stack.m_41779_() - holder.m_21212_()) / (float)drawtime;
    };
    private static final ResourceLocation CAST_ID = TConstruct.getResource("cast");
    private static final ItemPropertyFunction CAST = (stack, level, holder, seed) -> {
        if (holder instanceof Player) {
            ItemStack mainhand;
            Player player = (Player)holder;
            if (player.f_36083_ != null && stack.canPerformAction(ToolActions.FISHING_ROD_CAST) && ((mainhand = holder.m_21205_()) == stack || holder.m_21206_() == stack && !mainhand.canPerformAction(ToolActions.FISHING_ROD_CAST))) {
                return 1.0f;
            }
        }
        return 0.0f;
    };

    public static void registerBrokenProperty(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)BROKEN_ID, (ItemPropertyFunction)BROKEN);
    }

    public static void registerToolProperties(ItemLike itemlike) {
        Item item = itemlike.m_5456_();
        TinkerItemProperties.registerBrokenProperty(item);
        ItemProperties.register((Item)item, (ResourceLocation)CHARGING_ID, (ItemPropertyFunction)CHARGING);
        ItemProperties.register((Item)item, (ResourceLocation)CHARGE_ID, (ItemPropertyFunction)CHARGE);
        ItemProperties.register((Item)item, (ResourceLocation)CAST_ID, (ItemPropertyFunction)CAST);
    }

    public static void registerCrossbowProperties(ItemLike item) {
        TinkerItemProperties.registerToolProperties(item);
        ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)AMMO_ID, (ItemPropertyFunction)AMMO);
    }
}

