/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.gadgets.block.FoodCakeBlock;
import slimeknights.tconstruct.gadgets.block.InvertedCakeBlock;
import slimeknights.tconstruct.gadgets.block.PunjiBlock;
import slimeknights.tconstruct.gadgets.capability.PiggybackCapability;
import slimeknights.tconstruct.gadgets.data.GadgetRecipeProvider;
import slimeknights.tconstruct.gadgets.entity.EFLNEntity;
import slimeknights.tconstruct.gadgets.entity.FancyItemFrameEntity;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.gadgets.entity.GlowballEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.FlintShurikenEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.QuartzShurikenEntity;
import slimeknights.tconstruct.gadgets.item.EFLNItem;
import slimeknights.tconstruct.gadgets.item.FancyItemFrameItem;
import slimeknights.tconstruct.gadgets.item.GlowBallItem;
import slimeknights.tconstruct.gadgets.item.PiggyBackPackItem;
import slimeknights.tconstruct.gadgets.item.ShootProjectileDispenserBehavior;
import slimeknights.tconstruct.gadgets.item.ShurikenItem;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.world.block.FoliageType;

public final class TinkerGadgets
extends TinkerModule {
    public static final ItemObject<PunjiBlock> punji = BLOCKS.register("punji", () -> new PunjiBlock(TinkerGadgets.builder(MapColor.f_283915_, SoundType.f_56740_).m_60978_(3.0f).m_60956_(0.4f).m_60955_().m_278166_(PushReaction.DESTROY)), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<PiggyBackPackItem> piggyBackpack = ITEMS.register("piggy_backpack", () -> new PiggyBackPackItem(new Item.Properties().m_41487_(16)));
    public static final EnumObject<FrameType, FancyItemFrameItem> itemFrame = ITEMS.registerEnum(FrameType.values(), "item_frame", type -> new FancyItemFrameItem(ITEM_PROPS, (world, pos, dir) -> new FancyItemFrameEntity((Level)world, (BlockPos)pos, (Direction)dir, (FrameType)((Object)type))));
    @Deprecated
    public static final ItemObject<GlowBallItem> glowBall;
    @Deprecated
    public static final ItemObject<EFLNItem> efln;
    @Deprecated
    public static final ItemObject<ShurikenItem> quartzShuriken;
    @Deprecated
    public static final ItemObject<ShurikenItem> flintShuriken;
    public static final EnumObject<FoliageType, FoodCakeBlock> cake;
    public static final ItemObject<FoodCakeBlock> magmaCake;
    public static final RegistryObject<EntityType<FancyItemFrameEntity>> itemFrameEntity;
    @Deprecated
    public static final RegistryObject<EntityType<GlowballEntity>> glowBallEntity;
    @Deprecated
    public static final RegistryObject<EntityType<EFLNEntity>> eflnEntity;
    @Deprecated
    public static final RegistryObject<EntityType<QuartzShurikenEntity>> quartzShurikenEntity;
    @Deprecated
    public static final RegistryObject<EntityType<FlintShurikenEntity>> flintShurikenEntity;
    public static final RegistryObject<PiggyBackPackItem.CarryPotionEffect> carryEffect;

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        PiggybackCapability.register();
        event.enqueueWork(() -> {
            cake.forEach(block -> ComposterBlock.m_51920_((float)1.0f, (ItemLike)block));
            ComposterBlock.m_51920_((float)1.0f, (ItemLike)magmaCake.get());
            DispenserBlock.m_52672_(glowBall, (DispenseItemBehavior)new ShootProjectileDispenserBehavior((EntityType<? extends ThrowableItemProjectile>)((EntityType)glowBallEntity.get())));
            DispenserBlock.m_52672_(efln, (DispenseItemBehavior)new ShootProjectileDispenserBehavior((EntityType<? extends ThrowableItemProjectile>)((EntityType)eflnEntity.get())));
            DispenserBlock.m_52672_(flintShuriken, (DispenseItemBehavior)new ShootProjectileDispenserBehavior((EntityType<? extends ThrowableItemProjectile>)((EntityType)flintShurikenEntity.get())));
            DispenserBlock.m_52672_(quartzShuriken, (DispenseItemBehavior)new ShootProjectileDispenserBehavior((EntityType<? extends ThrowableItemProjectile>)((EntityType)quartzShurikenEntity.get())));
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new GadgetRecipeProvider(generator.getPackOutput()));
    }

    public static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(punji);
        TinkerGadgets.accept(output, itemFrame);
        output.m_246326_(piggyBackpack);
        TinkerGadgets.accept(output, cake);
        output.m_246326_(magmaCake);
    }

    static {
        Item.Properties THROWABLE_PROPS = new Item.Properties().m_41487_(16);
        glowBall = ITEMS.register("glow_ball", () -> new GlowBallItem(THROWABLE_PROPS));
        efln = ITEMS.register("efln_ball", () -> new EFLNItem(THROWABLE_PROPS));
        quartzShuriken = ITEMS.register("quartz_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, QuartzShurikenEntity::new));
        flintShuriken = ITEMS.register("flint_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, FlintShurikenEntity::new));
        BlockBehaviour.Properties CAKE = TinkerGadgets.builder(SoundType.f_56745_).m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY);
        cake = BLOCKS.registerEnum(FoliageType.values(), "cake", type -> {
            if (type == FoliageType.ICHOR) {
                return new InvertedCakeBlock(CAKE, TinkerFood.ICHOR_CAKE, FoodCakeBlock.EffectCombination.BLOCK);
            }
            return new FoodCakeBlock(CAKE, TinkerFood.getCake(type), type == FoliageType.ENDER ? FoodCakeBlock.EffectCombination.ADD : FoodCakeBlock.EffectCombination.BLOCK);
        }, UNSTACKABLE_BLOCK_ITEM);
        magmaCake = BLOCKS.register("magma_cake", () -> new FoodCakeBlock(CAKE, TinkerFood.MAGMA_CAKE, FoodCakeBlock.EffectCombination.BLOCK), UNSTACKABLE_BLOCK_ITEM);
        itemFrameEntity = ENTITIES.register("fancy_item_frame", () -> EntityType.Builder.m_20704_(FancyItemFrameEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, world) -> new FancyItemFrameEntity((EntityType<? extends FancyItemFrameEntity>)((EntityType)itemFrameEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(false));
        glowBallEntity = ENTITIES.register("glow_ball", () -> EntityType.Builder.m_20704_(GlowballEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new GlowballEntity((EntityType<? extends GlowballEntity>)((EntityType)glowBallEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
        eflnEntity = ENTITIES.register("efln_ball", () -> EntityType.Builder.m_20704_(EFLNEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new EFLNEntity((EntityType<? extends EFLNEntity>)((EntityType)eflnEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
        quartzShurikenEntity = ENTITIES.register("quartz_shuriken", () -> EntityType.Builder.m_20704_(QuartzShurikenEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new QuartzShurikenEntity((EntityType<? extends QuartzShurikenEntity>)((EntityType)quartzShurikenEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
        flintShurikenEntity = ENTITIES.register("flint_shuriken", () -> EntityType.Builder.m_20704_(FlintShurikenEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new FlintShurikenEntity((EntityType<? extends FlintShurikenEntity>)((EntityType)flintShurikenEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
        carryEffect = MOB_EFFECTS.register("carry", PiggyBackPackItem.CarryPotionEffect::new);
    }
}

