/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emiffect.recipe;

import com.mojang.datafixers.util.Pair;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.prismwork.emiffect.EMIffectPlugin;
import io.github.prismwork.emiffect.util.stack.StatusEffectEmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StatusEffectInfo
implements EmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<FormattedCharSequence> desc;
    private final ResourceLocation id;
    private int inputStackRow;
    private final StatusEffectEmiStack emiStack;

    public StatusEffectInfo(MobEffect effect, StatusEffectEmiStack emiStack) {
        this.id = BuiltInRegistries.f_256974_.m_7981_((Object)effect) != null ? BuiltInRegistries.f_256974_.m_7981_((Object)effect) : new ResourceLocation("emiffect", "missingno");
        ArrayList<EmiIngredient> inputs0 = new ArrayList<EmiIngredient>();
        block0: for (Potion potion : BuiltInRegistries.f_256980_) {
            for (MobEffectInstance instance : potion.m_43488_()) {
                if (!instance.m_19544_().equals(effect)) continue;
                inputs0.addAll(List.of(EmiStack.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)potion)), EmiStack.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42736_.m_7968_(), (Potion)potion)), EmiStack.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42739_.m_7968_(), (Potion)potion)), EmiStack.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42738_.m_7968_(), (Potion)potion))));
                continue block0;
            }
        }
        for (Block block : BuiltInRegistries.f_256975_) {
            if (!(block instanceof FlowerBlock)) continue;
            FlowerBlock flower = (FlowerBlock)block;
            ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
            MobEffect flowerEffect = flower.m_53521_();
            if (!flowerEffect.equals(effect)) continue;
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)200);
            inputs0.add((EmiIngredient)EmiStack.of((ItemStack)stew));
            break;
        }
        block3: for (Item item : BuiltInRegistries.f_257033_) {
            FoodProperties food = item.m_41473_();
            if (food == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            for (Pair pair : food.m_38749_()) {
                if (!((MobEffectInstance)pair.getFirst()).m_19544_().equals(effect)) continue;
                inputs0.add((EmiIngredient)EmiStack.of((ItemStack)stack));
                continue block3;
            }
        }
        for (MobEffect[] effects : BeaconBlockEntity.f_58646_) {
            if (!Arrays.asList(effects).contains(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((ItemLike)Blocks.f_50273_));
        }
        this.inputs = inputs0;
        this.desc = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)EmiPort.translatable((String)("effect." + this.id.m_135827_() + "." + this.id.m_135815_() + ".description")), 110);
        this.inputStackRow = this.inputs.isEmpty() ? 0 : 1;
        int inputColumn = 0;
        for (EmiIngredient ignored : this.inputs) {
            if (inputColumn >= 6) {
                ++this.inputStackRow;
                inputColumn = 0;
            }
            ++inputColumn;
        }
        this.emiStack = emiStack;
    }

    public EmiRecipeCategory getCategory() {
        return EMIffectPlugin.CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emiffect", "effects/" + this.id.m_135827_() + "/" + this.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.emiStack);
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int n = this.desc.size();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 14 + Math.max(n * 9, 30) + 4 + this.inputStackRow * 18 + 2;
    }

    public void addWidgets(WidgetHolder widgets) {
        int titleColor = 0xFFFFFF;
        if (this.emiStack.getEffect() != null) {
            switch (this.emiStack.getEffect().m_19483_()) {
                case BENEFICIAL: {
                    titleColor = ChatFormatting.GREEN.m_126665_();
                    break;
                }
                case NEUTRAL: {
                    titleColor = ChatFormatting.GOLD.m_126665_();
                    break;
                }
                case HARMFUL: {
                    titleColor = ChatFormatting.RED.m_126665_();
                }
            }
        }
        FormattedCharSequence title = this.emiStack.getName().m_7532_();
        int titleX = 31 + (113 - Minecraft.m_91087_().f_91062_.m_92724_(title)) / 2;
        widgets.addText(title, titleX, 2, titleColor, true);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        int descLine = 0;
        for (FormattedCharSequence text : this.desc) {
            widgets.addText(text, 31, 14 + lineHeight * descLine, 0xFFFFFF, true);
            ++descLine;
        }
        int descHeight = Math.max(descLine * lineHeight, 30);
        descHeight += 12;
        int inputRow = 0;
        int inputColumn = 0;
        for (EmiIngredient ingredient : this.inputs) {
            widgets.addSlot(ingredient, 18 + inputColumn * 18, descHeight + 4 + inputRow * 18);
            if (++inputColumn < 6) continue;
            ++inputRow;
            inputColumn = 0;
        }
        SlotWidget effectSlot = new SlotWidget((EmiIngredient)this.emiStack, 3, (descHeight - 26) / 2).large(true);
        widgets.add((Widget)effectSlot);
    }
}

