/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;

public class SolarFluxResourcePack
implements PackResources {
    public final Map<ResourceLocation, IResourceStreamSupplier> resourceMap = new HashMap<ResourceLocation, IResourceStreamSupplier>();
    static SolarFluxResourcePack packInstance;
    private boolean hasInit = false;

    private static IResourceStreamSupplier ofText(String text) {
        return IResourceStreamSupplier.create(() -> true, () -> new ByteArrayInputStream(text.getBytes()));
    }

    private static IResourceStreamSupplier ofFile(File file) {
        return IResourceStreamSupplier.create(file::isFile, () -> new FileInputStream(file));
    }

    private static IResourceStreamSupplier oneOfFiles(File ... file) {
        return IResourceStreamSupplier.create(() -> Arrays.stream(file).anyMatch(File::isFile), () -> new FileInputStream(Arrays.stream(file).filter(File::isFile).findFirst().orElseThrow(FileNotFoundException::new)));
    }

    public static SolarFluxResourcePack getPackInstance() {
        if (packInstance == null) {
            packInstance = new SolarFluxResourcePack();
        }
        return packInstance;
    }

    public void init() {
        if (this.hasInit) {
            return;
        }
        this.hasInit = true;
        this.resourceMap.clear();
        File textures = new File(SolarPanelsSF.CONFIG_DIR, "textures");
        ItemsSF.JS_MATERIALS.forEach(i -> {
            ResourceLocation reg = i.getRegistryName();
            ResourceLocation models_item = new ResourceLocation(reg.m_135827_(), "models/item/" + reg.m_135815_() + ".json");
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"item/generated\",\"textures\":{\"layer0\":\"" + reg.m_135827_() + ":item/materials/" + reg.m_135815_() + "\"}}"));
            File items = new File(textures, "item");
            ResourceLocation textures_items = new ResourceLocation(reg.m_135827_(), "textures/item/materials/" + reg.m_135815_() + ".png");
            this.resourceMap.put(textures_items, SolarFluxResourcePack.ofFile(new File(items, reg.m_135815_() + ".png")));
        });
        SolarPanelsSF.listPanels().forEach(si -> {
            SolarPanelBlock blk = si.getBlock();
            ResourceLocation reg = ForgeRegistries.BLOCKS.getKey((Object)blk);
            ResourceLocation blockstate = new ResourceLocation(reg.m_135827_(), "blockstates/" + reg.m_135815_() + ".json");
            ResourceLocation models_block = new ResourceLocation(reg.m_135827_(), "models/block/" + reg.m_135815_() + ".json");
            ResourceLocation models_item = new ResourceLocation(reg.m_135827_(), "models/item/" + reg.m_135815_() + ".json");
            this.resourceMap.put(blockstate, SolarFluxResourcePack.ofText("{\"variants\":{\"\":{\"model\":\"" + reg.m_135827_() + ":block/" + reg.m_135815_() + "\"}}}"));
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"" + reg.m_135827_() + ":block/" + reg.m_135815_() + "\"}"));
            JSONObject blockModel = new JSONObject();
            blockModel.put("loader", (Object)"solarflux:solar_panel");
            blockModel.put("panel", (Object)reg.toString());
            this.resourceMap.put(models_block, SolarFluxResourcePack.ofText(blockModel.toString()));
            if (si.isCustom) {
                File blocks = new File(textures, "block");
                ResourceLocation textures_blocks_base = new ResourceLocation(reg.m_135827_(), "textures/block/" + reg.m_135815_() + "_base.png");
                ResourceLocation textures_blocks_top = new ResourceLocation(reg.m_135827_(), "textures/block/" + reg.m_135815_() + "_top.png");
                ResourceLocation textures_blocks_base_mcmeta = new ResourceLocation(reg.m_135827_(), "textures/block/" + reg.m_135815_() + "_base.png.mcmeta");
                ResourceLocation textures_blocks_top_mcmeta = new ResourceLocation(reg.m_135827_(), "textures/block/" + reg.m_135815_() + "_top.png.mcmeta");
                String n = reg.m_135815_().startsWith("sp_custom_") ? reg.m_135815_().substring(10) : reg.m_135815_().substring(3);
                this.resourceMap.put(textures_blocks_base, SolarFluxResourcePack.ofFile(new File(blocks, n + "_base.png")));
                this.resourceMap.put(textures_blocks_base_mcmeta, SolarFluxResourcePack.oneOfFiles(new File(blocks, n + "_base.mcmeta"), new File(blocks, n + "_base.png.mcmeta")));
                this.resourceMap.put(textures_blocks_top, SolarFluxResourcePack.ofFile(new File(blocks, n + "_top.png")));
                this.resourceMap.put(textures_blocks_top_mcmeta, SolarFluxResourcePack.oneOfFiles(new File(blocks, n + "_top.mcmeta"), new File(blocks, n + "_top.png.mcmeta")));
            }
        });
    }

    public void close() {
    }

    public boolean isHidden() {
        return true;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... path) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        IResourceStreamSupplier res = this.resourceMap.get(location);
        if (res == null) {
            return null;
        }
        if (!res.exists()) {
            return null;
        }
        return () -> {
            try {
                this.init();
                return res.create();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        };
    }

    public void m_8031_(PackType type, String namespace, String dir, PackResources.ResourceOutput out) {
        if (!namespace.equals("solarflux")) {
            return;
        }
        this.init();
        for (Map.Entry<ResourceLocation, IResourceStreamSupplier> e : this.resourceMap.entrySet()) {
            if (!e.getKey().m_135815_().startsWith(dir) || !e.getValue().exists()) continue;
            out.accept((Object)e.getKey(), e.getValue()::create);
        }
    }

    public Set<String> m_5698_(PackType type) {
        this.init();
        return Collections.singleton("solarflux");
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.m_7991_().equals("pack")) {
            JsonObject obj = new JsonObject();
            obj.addProperty("pack_format", (Number)SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            obj.addProperty("description", "Generated resources for SolarFlux");
            return (T)deserializer.m_6322_(obj);
        }
        return null;
    }

    public String m_5542_() {
        return "SolarFlux";
    }

    @FunctionalInterface
    public static interface IIOSupplier<T> {
        public T get() throws IOException;
    }

    public static interface IResourceStreamSupplier {
        public static IResourceStreamSupplier create(final BooleanSupplier exists, final IIOSupplier<InputStream> streamable) {
            return new IResourceStreamSupplier(){

                @Override
                public boolean exists() {
                    return exists.getAsBoolean();
                }

                @Override
                public InputStream create() throws IOException {
                    return (InputStream)streamable.get();
                }
            };
        }

        public boolean exists();

        public InputStream create() throws IOException;
    }
}

