/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> internalMap;
    private final ReentrantLock lock = new ReentrantLock();

    public CopyOnWriteHashMap() {
        this.internalMap = new HashMap();
    }

    public CopyOnWriteHashMap(Map<? extends K, ? extends V> m) {
        this.internalMap = new HashMap<K, V>(m);
    }

    @Override
    public V get(Object key) {
        return this.internalMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.lock();
        try {
            HashMap<K, V> newMap = new HashMap<K, V>(this.internalMap);
            V oldValue = newMap.put(key, value);
            this.internalMap = newMap;
            V v = oldValue;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.lock.lock();
        try {
            HashMap<? extends K, ? extends V> newMap = new HashMap<K, V>(this.internalMap);
            newMap.putAll(m);
            this.internalMap = newMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.lock.lock();
        try {
            HashMap<K, V> newMap = new HashMap<K, V>(this.internalMap);
            Object oldValue = newMap.remove(key);
            this.internalMap = newMap;
            Object v = oldValue;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.internalMap = new HashMap();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.internalMap.keySet());
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.internalMap.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.internalMap.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.lock.lock();
        try {
            if (!this.internalMap.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = this.internalMap.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.lock.lock();
        try {
            if (this.internalMap.containsKey(key) && Objects.equals(this.internalMap.get(key), value)) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.lock.lock();
        try {
            if (this.internalMap.containsKey(key) && Objects.equals(this.internalMap.get(key), oldValue)) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.lock.lock();
        try {
            if (this.internalMap.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.internalMap.toString();
    }
}

