/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.screen.ConfigContainerScreen;
import com.iafenvoy.jupiter.render.screen.SingleConfigScreen;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public interface JupiterScreen {
    public static final int ENTRIES_PER_SCROLL = 2;
    public static final int ENTRY_HEIGHT = 20;
    public static final int ENTRY_SEPARATOR = 5;

    public static Screen getConfigScreen(Screen parent, AbstractConfigContainer container, boolean client) {
        List<ConfigGroup> groups = container.getConfigTabs();
        if (groups.size() == 1) {
            return new SingleConfigScreen(parent, container, client);
        }
        return new ConfigContainerScreen(parent, container, client);
    }

    public static boolean connectedToDedicatedServer() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener handler = minecraft.m_91403_();
        IntegratedServer server = minecraft.m_91092_();
        return handler != null && handler.m_104910_().m_129536_() && (server == null || server.m_6982_());
    }

    public static Button createButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
        return JupiterScreen.createButtonWithTooltip(null, x, y, width, height, text, onPress, null);
    }

    public static Button createButtonWithTooltip(Screen self, int x, int y, int width, int height, Component text, Button.OnPress onPress, @Nullable Component tooltip) {
        Button.Builder builder = Button.m_253074_((Component)text, (Button.OnPress)onPress).m_252987_(x, y, width, height);
        if (tooltip != null) {
            builder.m_257505_(Tooltip.m_257550_((Component)tooltip));
        }
        return builder.m_253136_();
    }

    public static Pair<Button, Consumer<Component>> createButtonWithDynamicTooltip(Screen self, int x, int y, int width, int height, Component text, Button.OnPress onPress, Component tooltip) {
        Button button = JupiterScreen.createButtonWithTooltip(self, x, y, width, height, text, onPress, tooltip);
        return Pair.of((Object)button, c -> button.m_257544_(Tooltip.m_257550_((Component)c)));
    }
}

