/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    @Nullable
    private final AbstractConfigContainer common;
    @Nullable
    private final AbstractConfigContainer client;
    @Nullable
    private final AbstractConfigContainer server;
    private final boolean displayCommon;

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ConfigSelectScreen(Component title, Screen parent, @Nullable FileConfigContainer serverConfig, @Nullable FileConfigContainer clientConfig) {
        super(title);
        this.parent = parent;
        this.server = serverConfig;
        this.client = clientConfig;
        this.common = null;
        this.displayCommon = false;
    }

    protected ConfigSelectScreen(Component title, Screen parent, @Nullable AbstractConfigContainer common, @Nullable AbstractConfigContainer client, @Nullable AbstractConfigContainer server, boolean displayCommon) {
        super(title);
        this.parent = parent;
        this.common = common;
        this.client = client;
        this.server = server;
        this.displayCommon = displayCommon;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)JupiterScreen.createButton(x - 100, y - (this.displayCommon ? 60 : 45), 200, 20, (Component)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(this.parent);
        }));
        boolean connectedToRemote = JupiterScreen.connectedToDedicatedServer();
        if (this.displayCommon) {
            ((Button)this.m_142416_((GuiEventListener)JupiterScreen.createButtonWithTooltip((Screen)this, (int)(x - 100), (int)(y - 30), (int)95, (int)20, (Component)TextUtil.translatable((String)"jupiter.screen.local_common_config", (Object[])new Object[0]), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((ConfigSelectScreen)this), (Component)TextUtil.translatable((String)(this.common != null ? "jupiter.screen.open_local_common" : "jupiter.screen.unavailable"), (Object[])new Object[0])))).f_93623_ = this.common != null;
            Pair<Button, Consumer<Component>> commonPair = JupiterScreen.createButtonWithDynamicTooltip(this, x + 5, y - 30, 95, 20, (Component)TextUtil.translatable("jupiter.screen.remote_common_config", new Object[0]), button -> {
                assert (this.f_96541_ != null && this.common != null);
                this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, new RemoteConfigWrapper(this.common), false));
            }, (Component)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
            boolean bl = ((Button)this.m_142416_((GuiEventListener)((Button)commonPair.getFirst()))).f_93623_ = this.common != null && connectedToRemote;
            if (this.common != null) {
                if (connectedToRemote) {
                    ConfigSelectScreen.handleRemoteConfig(this.common, "jupiter.screen.open_remote_common", b -> {
                        ((Button)commonPair.getFirst()).f_93623_ = b;
                    }, (Consumer)commonPair.getSecond());
                } else {
                    ((Consumer)commonPair.getSecond()).accept(TextUtil.translatable("jupiter.screen.need_remote_server", new Object[0]));
                }
            }
        }
        ((Button)this.m_142416_((GuiEventListener)JupiterScreen.createButtonWithTooltip((Screen)this, (int)(x - 100), (int)(y - (this.displayCommon ? 0 : 15)), (int)95, (int)20, (Component)TextUtil.translatable((String)"jupiter.screen.local_server_config", (Object[])new Object[0]), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$4(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((ConfigSelectScreen)this), (Component)TextUtil.translatable((String)(this.server != null ? "jupiter.screen.open_local_server" : "jupiter.screen.unavailable"), (Object[])new Object[0])))).f_93623_ = this.server != null;
        Pair<Button, Consumer<Component>> serverPair = JupiterScreen.createButtonWithDynamicTooltip(this, x + 5, y - (this.displayCommon ? 0 : 15), 95, 20, (Component)TextUtil.translatable("jupiter.screen.remove_server_config", new Object[0]), button -> {
            assert (this.f_96541_ != null && this.server != null);
            this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, new RemoteConfigWrapper(this.server), false));
        }, (Component)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
        boolean bl = ((Button)this.m_142416_((GuiEventListener)((Button)serverPair.getFirst()))).f_93623_ = this.server != null && connectedToRemote;
        if (this.server != null) {
            if (connectedToRemote) {
                ConfigSelectScreen.handleRemoteConfig(this.server, "jupiter.screen.open_remote_server", b -> {
                    ((Button)serverPair.getFirst()).f_93623_ = b;
                }, (Consumer)serverPair.getSecond());
            } else {
                ((Consumer)serverPair.getSecond()).accept(TextUtil.translatable("jupiter.screen.need_remote_server", new Object[0]));
            }
        }
        ((Button)this.m_142416_((GuiEventListener)JupiterScreen.createButtonWithTooltip((Screen)this, (int)(x - 100), (int)(y + (this.displayCommon ? 30 : 15)), (int)200, (int)20, (Component)TextUtil.translatable((String)"jupiter.screen.client_config", (Object[])new Object[0]), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$7(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((ConfigSelectScreen)this), (Component)TextUtil.translatable((String)(this.client != null ? "jupiter.screen.open_client" : "jupiter.screen.unavailable"), (Object[])new Object[0])))).f_93623_ = this.client != null;
    }

    private static void handleRemoteConfig(AbstractConfigContainer container, String openKey, BooleanConsumer buttonActive, Consumer<Component> tooltip) {
        tooltip.accept((Component)TextUtil.translatable("jupiter.screen.check_server", new Object[0]));
        buttonActive.accept(false);
        ClientConfigNetwork.syncConfig(container.getConfigId(), nbt -> {
            if (nbt == null) {
                tooltip.accept((Component)TextUtil.translatable("jupiter.screen.disable_server", new Object[0]));
            } else {
                try {
                    container.deserializeNbt((CompoundTag)nbt);
                    tooltip.accept((Component)TextUtil.translatable(openKey, new Object[0]));
                    buttonActive.accept(true);
                }
                catch (Exception e) {
                    Jupiter.LOGGER.error("Failed to parse config data from server: {}", (Object)container.getConfigId(), (Object)e);
                    tooltip.accept((Component)TextUtil.translatable("jupiter.screen.error_server", new Object[0]));
                }
            }
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        assert (this.f_96541_ != null);
        graphics.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - (this.displayCommon ? 80 : 65), -1);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return true;
    }

    public static Builder builder(String titleKey, Screen parent) {
        return new Builder(titleKey, parent);
    }

    public static Builder builder(Component title, Screen parent) {
        return new Builder(title, parent);
    }

    private /* synthetic */ void lambda$init$7(Button button) {
        assert (this.f_96541_ != null);
        assert (this.client != null);
        this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.client, true));
    }

    private /* synthetic */ void lambda$init$4(Button button) {
        assert (this.f_96541_ != null);
        assert (this.server != null);
        this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.server, true));
    }

    private /* synthetic */ void lambda$init$1(Button button) {
        assert (this.f_96541_ != null);
        assert (this.common != null);
        this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.common, true));
    }

    public static class Builder {
        private final Component title;
        private final Screen parent;
        private AbstractConfigContainer common;
        private AbstractConfigContainer client;
        private AbstractConfigContainer server;
        private boolean displayCommon = false;

        public Builder(String titleKey, Screen parent) {
            this((Component)TextUtil.translatable(titleKey, new Object[0]), parent);
        }

        public Builder(Component title, Screen parent) {
            this.title = title;
            this.parent = parent;
        }

        public Builder common(AbstractConfigContainer common) {
            this.common = common;
            return this.displayCommon();
        }

        public Builder displayCommon() {
            this.displayCommon = true;
            return this;
        }

        public Builder client(AbstractConfigContainer client) {
            this.client = client;
            return this;
        }

        public Builder server(AbstractConfigContainer server) {
            this.server = server;
            return this;
        }

        public ConfigSelectScreen build() {
            return new ConfigSelectScreen(this.title, this.parent, this.common, this.client, this.server, this.displayCommon);
        }
    }
}

