/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.BadgeRenderer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class JupiterConfigListWidget
extends ObjectSelectionList<Entry> {
    private final JupiterConfigListScreen screen;
    private final List<Entry> entries = new ArrayList<Entry>();
    private String filter = "";

    public JupiterConfigListWidget(JupiterConfigListScreen screen, Minecraft client, int width, int height, int y, int bottom) {
        super(client, width, height, y, bottom, 32);
        this.screen = screen;
        this.m_93496_(false);
    }

    public void update() {
        this.entries.clear();
        for (AbstractConfigContainer x : ConfigManager.getInstance().getConfigs()) {
            this.entries.add(new Entry(this, x));
        }
        this.updateEntries();
    }

    private void updateEntries() {
        this.m_93516_();
        this.entries.stream().filter(x -> x.match(this.filter)).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        this.m_93410_(0.0);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateEntries();
    }

    protected int m_5756_() {
        return this.f_93392_ - 8;
    }

    public int m_5759_() {
        return this.f_93388_ - 4;
    }

    public void setSelected(@Nullable Entry selected) {
        super.m_6987_((AbstractSelectionList.Entry)selected);
        this.screen.updateButtonState();
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final Minecraft client = Minecraft.m_91087_();
        private final JupiterConfigListWidget widget;
        private final AbstractConfigContainer handler;

        public Entry(JupiterConfigListWidget widget, AbstractConfigContainer handler) {
            this.widget = widget;
            this.handler = handler;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            graphics.m_280430_(this.client.f_91062_, this.handler.getTitle(), x + 65, y + 1, -1);
            graphics.m_280488_(this.client.f_91062_, this.handler.getConfigId().toString(), x + 65, y + 1 + 9, -8421505);
            graphics.m_280488_(this.client.f_91062_, this.handler.getPath(), x + 65, y + 1 + 18, -8421505);
            ConfigSource source = this.handler.getSource();
            ConfigSide side = this.handler.getSide();
            BadgeRenderer.draw(graphics, this.client.f_91062_, x + 1, y + 1, source.name(), source.color());
            BadgeRenderer.draw(graphics, this.client.f_91062_, x + 1, y + 16, (Component)TextUtil.literal(side.getDisplayText()), side.getColor());
        }

        public boolean m_6375_(double x, double y, int button) {
            this.widget.setSelected(this);
            return false;
        }

        public AbstractConfigContainer getConfigContainer() {
            return this.handler;
        }

        @NotNull
        public Component m_142172_() {
            return TextUtil.empty();
        }

        public boolean match(String filter) {
            return this.handler.getTitle().getString().toLowerCase(Locale.ROOT).contains(filter) || this.handler.getConfigId().toString().contains(filter) || this.handler.getPath().contains(filter) || this.handler.getSource().name().getString().toLowerCase(Locale.ROOT).contains(filter) || this.handler.getSide().name().toLowerCase(Locale.ROOT).contains(filter);
        }
    }
}

