/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public final class TitleStack {
    private static final Component OMIT = TextUtil.literal("...");
    private static final Component SEPARATOR = TextUtil.literal(" -> ").m_130940_(ChatFormatting.GRAY);
    private final Font font;
    private final List<Component> titles;
    private MutableComponent cachedTitle;

    private TitleStack(List<Component> titles) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.cachedTitle = TextUtil.empty();
        this.titles = titles;
    }

    public TitleStack push(Component title) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.titles);
        builder.add((Object)title);
        return new TitleStack((List<Component>)builder.build());
    }

    public static TitleStack create(Component title) {
        return new TitleStack(List.of(title));
    }

    public void cacheTitle(int width) {
        if (this.titles.isEmpty()) {
            return;
        }
        MutableComponent part = TextUtil.empty();
        this.cachedTitle = TextUtil.empty();
        for (int i = this.titles.size() - 1; i >= 0; --i) {
            boolean first;
            boolean bl = first = i == this.titles.size() - 1;
            if (first) {
                part.m_7220_(this.titles.get(i));
                if (i > 0) {
                    this.cachedTitle.m_7220_(OMIT).m_7220_(SEPARATOR);
                }
                this.cachedTitle.m_7220_((Component)part);
                continue;
            }
            part = TextUtil.empty().m_7220_(this.titles.get(i)).m_7220_(SEPARATOR).m_7220_((Component)part);
            MutableComponent component = TextUtil.empty();
            if (i > 0) {
                component.m_7220_(OMIT).m_7220_(SEPARATOR);
            }
            component.m_7220_((Component)part);
            if (this.font.m_92852_((FormattedText)component) > width) break;
            this.cachedTitle = component;
        }
    }

    public Component getTitle() {
        return this.cachedTitle;
    }
}

