/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat.clothconfig;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.compat.ExtraConfigHolder;
import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.entry.BooleanEntry;
import com.iafenvoy.jupiter.config.entry.ConfigGroupEntry;
import com.iafenvoy.jupiter.config.entry.DoubleEntry;
import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.FloatEntry;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListBooleanEntry;
import com.iafenvoy.jupiter.config.entry.ListDoubleEntry;
import com.iafenvoy.jupiter.config.entry.ListIntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListLongEntry;
import com.iafenvoy.jupiter.config.entry.ListStringEntry;
import com.iafenvoy.jupiter.config.entry.LongEntry;
import com.iafenvoy.jupiter.config.entry.StringEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigBuilder;
import com.iafenvoy.jupiter.config.interfaces.ConfigEntry;
import com.iafenvoy.jupiter.util.JupiterUtils;
import com.iafenvoy.jupiter.util.TextUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public final class ClothConfigHolder<D extends ConfigData>
implements ExtraConfigHolder {
    private final ConfigManager<D> manager;
    private final String modId;
    private final D values;
    private final D defaults;

    public ClothConfigHolder(ConfigManager<D> manager) {
        this.manager = manager;
        this.modId = this.manager.getDefinition().name().toLowerCase(Locale.ROOT);
        this.values = manager.getConfig();
        this.defaults = manager.getSerializer().createDefault();
    }

    public String getModId() {
        return this.modId;
    }

    @Override
    public ResourceLocation getConfigId() {
        return Jupiter.id(this.modId, "config");
    }

    @Override
    public String getPath() {
        return this.modId + ".json";
    }

    public String baseTranslateKey() {
        return "text.autoconfig.%s".formatted(this.modId);
    }

    @Override
    public Component getTitle() {
        return TextUtil.translatable("%s.title".formatted(this.baseTranslateKey()), new Object[0]);
    }

    @Override
    public ConfigSide getSide() {
        return ConfigSide.UNKNOWN;
    }

    @Override
    public ConfigSource getSource() {
        return ConfigSource.CLOTH_CONFIG;
    }

    @Override
    public void save() {
        this.manager.save();
    }

    @Override
    public Collection<? extends ConfigGroup> buildGroups() {
        return List.of(this.buildGroup(this.getConfigId().toString(), "%s.option".formatted(this.baseTranslateKey()), this.defaults, this.values));
    }

    public <T> ConfigGroup buildGroup(String id, String baseKey, T defaults, T values) {
        ConfigGroup group = new ConfigGroup(id, (Component)TextUtil.translatable(baseKey, new Object[0]));
        for (Field field : defaults.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !field.canAccess(defaults) || field.getAnnotation(ConfigEntry.Gui.Excluded.class) != null) continue;
            try {
                String nameKey = "%s.%s".formatted(baseKey, field.getName());
                ConfigGroupEntry.Builder builder = this.process(nameKey, defaults, values, field);
                if (builder == null) {
                    builder = ConfigGroupEntry.builder(nameKey, this.buildGroup(field.getName(), nameKey, field.get(defaults), field.get(values)));
                }
                if (field.getAnnotation(ConfigEntry.Gui.Tooltip.class) != null) {
                    builder.tooltip("%s.@Tooltip".formatted(nameKey));
                }
                group.addEntry((ConfigEntry<?>)builder.build());
            }
            catch (Exception e) {
                Jupiter.LOGGER.error("Failed to load field {} class {} from class {}", new Object[]{field.getName(), field.getType(), defaults.getClass().getName(), e});
            }
        }
        return group;
    }

    private <T> ConfigBuilder<?, ?, ?> process(String nameKey, T defaults, T values, Field field) {
        AtomicReference<Object> holder = new AtomicReference<Object>(null);
        MutableComponent name = TextUtil.translatable(nameKey, new Object[0]);
        this.processEntry(holder, (Component)name, field, defaults, values, Boolean.class, BooleanEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Integer.class, IntegerEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Long.class, LongEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Double.class, DoubleEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Float.class, FloatEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, String.class, StringEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Enum.class, EnumEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Boolean.TYPE, BooleanEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Integer.TYPE, IntegerEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Long.TYPE, LongEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Double.TYPE, DoubleEntry::builder);
        this.processEntry(holder, (Component)name, field, defaults, values, Float.TYPE, FloatEntry::builder);
        if (field.getType().isArray()) {
            this.processArrayEntry(holder, (Component)name, field, defaults, values, Boolean.class, ListBooleanEntry::builder);
            this.processArrayEntry(holder, (Component)name, field, defaults, values, Integer.class, ListIntegerEntry::builder);
            this.processArrayEntry(holder, (Component)name, field, defaults, values, Long.class, ListLongEntry::builder);
            this.processArrayEntry(holder, (Component)name, field, defaults, values, Double.class, ListDoubleEntry::builder);
            this.processArrayEntry(holder, (Component)name, field, defaults, values, String.class, ListStringEntry::builder);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            this.processCollectionEntry(holder, (Component)name, field, defaults, values, Boolean.class, ListBooleanEntry::builder);
            this.processCollectionEntry(holder, (Component)name, field, defaults, values, Integer.class, ListIntegerEntry::builder);
            this.processCollectionEntry(holder, (Component)name, field, defaults, values, Long.class, ListLongEntry::builder);
            this.processCollectionEntry(holder, (Component)name, field, defaults, values, Double.class, ListDoubleEntry::builder);
            this.processCollectionEntry(holder, (Component)name, field, defaults, values, String.class, ListStringEntry::builder);
        }
        return holder.get();
    }

    private <V, T, B extends ConfigBuilder<T, ?, B>> void processEntry(AtomicReference<ConfigBuilder<?, ?, ?>> reference, Component name, Field field, V defaults, V values, Class<T> clazz, BiFunction<Component, T, B> entryProvider) {
        if (clazz.isAssignableFrom(field.getType())) {
            ConfigBuilder builder = (ConfigBuilder)entryProvider.apply(name, (Component)Utils.getUnsafely((Field)field, defaults));
            builder.callback((v, r, d) -> Utils.setUnsafely((Field)field, (Object)values, (Object)v)).value((Object)Utils.getUnsafely((Field)field, values));
            reference.set(builder);
        }
    }

    private <V, T, B extends ConfigBuilder<List<T>, ?, B>> void processArrayEntry(AtomicReference<ConfigBuilder<?, ?, ?>> reference, Component name, Field field, V defaults, V values, Class<T> clazz, BiFunction<Component, List<T>, B> entryProvider) {
        if (clazz.isAssignableFrom((Class<?>)field.getType().componentType())) {
            ConfigBuilder builder = (ConfigBuilder)entryProvider.apply(name, List.of((Object[])Utils.getUnsafely((Field)field, defaults)));
            builder.callback((v, r, d) -> Utils.setUnsafely((Field)field, (Object)values, (Object)v.toArray((Object[])Array.newInstance(clazz, 0)))).value(List.of((Object[])Utils.getUnsafely((Field)field, values)));
            reference.set(builder);
        }
    }

    private <V, T, B extends ConfigBuilder<List<T>, ?, B>> void processCollectionEntry(AtomicReference<ConfigBuilder<?, ?, ?>> reference, Component name, Field field, V defaults, V values, Class<T> clazz, BiFunction<Component, List<T>, B> entryProvider) {
        Class<?> actual = JupiterUtils.getGenericActualClass(field);
        if (actual != null && clazz.isAssignableFrom(actual)) {
            ConfigBuilder builder = (ConfigBuilder)entryProvider.apply(name, (List)Utils.getUnsafely((Field)field, defaults));
            builder.callback((v, r, d) -> Utils.setUnsafely((Field)field, (Object)values, (Object)v)).value((List)((List)Utils.getUnsafely((Field)field, values)));
            reference.set(builder);
        }
    }
}

