/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.block.BlockEnderChest;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class RenderTileEnderChest
implements BlockEntityRenderer<TileEnderChest> {
    private static final RenderType chestType = RenderType.m_110452_((ResourceLocation)new ResourceLocation("enderstorage:textures/enderchest.png"));
    private static final RenderType buttonType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("enderstorage:textures/buttons.png"));
    private static final RenderType pearlType = CCModelLibrary.getIcos4RenderType((ResourceLocation)new ResourceLocation("enderstorage:textures/hedronmap.png"));
    private static final RenderCustomEndPortal renderEndPortal = new RenderCustomEndPortal(0.626, 0.188, 0.812, 0.188, 0.812);
    private final ModelPart bottom;
    private final ModelPart lid;
    private final ModelPart lock;
    private final ModelPart diamondLock;

    public RenderTileEnderChest(BlockEntityRendererProvider.Context context) {
        ModelPart chestRoot = RenderTileEnderChest.createChestLayer().m_171564_();
        this.bottom = chestRoot.m_171324_("bottom");
        this.lid = chestRoot.m_171324_("lid");
        this.lock = chestRoot.m_171324_("lock");
        this.diamondLock = chestRoot.m_171324_("diamond_lock");
    }

    public static LayerDefinition createChestLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 0.0f, 14.0f, 10.0f, 14.0f), PartPose.m_171419_((float)1.0f, (float)6.0f, (float)1.0f));
        root.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -5.0f, -14.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)1.0f, (float)7.0f, (float)15.0f));
        root.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -2.0f, -15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)8.0f, (float)7.0f, (float)15.0f));
        root.m_171599_("diamond_lock", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-1.0f, -2.0f, -15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)8.0f, (float)7.0f, (float)15.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(TileEnderChest enderChest, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        this.renderChest(ccrs, mStack, getter, enderChest.rotation, enderChest.getFrequency(), (float)enderChest.getRadianLidAngle(partialTicks), RenderUtils.getTimeOffset((BlockPos)enderChest.m_58899_()));
    }

    public void renderChest(CCRenderState ccrs, PoseStack pose, MultiBufferSource source, int rotation, Frequency freq, float lidAngle, int pearlOffset) {
        Matrix4 mat = new Matrix4(pose);
        if (lidAngle != 0.0f) {
            renderEndPortal.render(mat, source);
        }
        ccrs.reset();
        pose.m_85836_();
        pose.m_85837_(0.0, 1.0, 1.0);
        pose.m_85841_(1.0f, -1.0f, -1.0f);
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_252781_(new Quaternionf().rotateXYZ(0.0f, (float)((double)((float)rotation * 90.0f) * 0.017453292519943), 0.0f));
        pose.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer chestCons = source.m_6299_(chestType);
        this.lid.f_104203_ = lidAngle;
        this.lock.f_104203_ = lidAngle;
        this.diamondLock.f_104203_ = lidAngle;
        this.lid.m_104301_(pose, chestCons, ccrs.brightness, ccrs.overlay);
        this.bottom.m_104301_(pose, chestCons, ccrs.brightness, ccrs.overlay);
        if (freq.hasOwner()) {
            this.diamondLock.m_104301_(pose, chestCons, ccrs.brightness, ccrs.overlay);
        } else {
            this.lock.m_104301_(pose, chestCons, ccrs.brightness, ccrs.overlay);
        }
        pose.m_85849_();
        mat.translate(0.5, 0.0, 0.5);
        ccrs.bind(buttonType, source);
        Matrix4 buttonCommon = mat.copy();
        buttonCommon.rotate((double)(-90 * rotation) * 0.017453292519943, Vector3.Y_POS);
        buttonCommon.apply(new Rotation((double)lidAngle, 1.0, 0.0, 0.0).at(new Vector3(-0.5, 0.5625, -0.4375)));
        EnumColour[] colours = freq.toArray();
        for (int i = 0; i < 3; ++i) {
            Matrix4 buttonMat = buttonCommon.copy();
            buttonMat.apply(BlockEnderChest.buttonT[i]);
            ButtonModelLibrary.button.render(ccrs, new IVertexOperation[]{buttonMat, new UVTranslation(0.25 * (double)(colours[i].getWoolMeta() % 4), 0.25 * (double)(colours[i].getWoolMeta() / 4))});
        }
        if (lidAngle != 0.0f) {
            double time = ClientUtils.getRenderTime() + (double)pearlOffset;
            Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)mat.copy(), (Vector3)new Vector3(0.0, 0.2 + (double)lidAngle * -0.5 + (double)RenderUtils.getPearlBob((double)time), 0.0), (Rotation)new Rotation(time / 3.0, new Vector3(0.0, 1.0, 0.0)), (double)0.04);
            ccrs.brightness = 0xF000F0;
            ccrs.bind(pearlType, source);
            CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        }
        ccrs.reset();
    }
}

