/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tconstruct;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class RepairKit
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("tconstruct_repair_kit");
    public static final Component SHORT_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tconstruct_repair_kit"));
    public static final Component LONG_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tconstruct_repair_kit.desc"));
    private final MaterialVariantId variantId;
    private final int count;
    private List<ItemStack> examples;

    public RepairKit(MaterialVariantId variantId, int count) {
        this.variantId = variantId;
        this.count = count;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static RepairKit deserialize(IFactoryController controller, CompoundTag tag) {
        MaterialVariantId variantId = MaterialVariantId.tryParse((String)tag.m_128461_("variantId"));
        int count = tag.m_128451_("count");
        return new RepairKit(variantId, count);
    }

    public static void serialize(IFactoryController controller, CompoundTag tag, RepairKit request) {
        tag.m_128359_("variantId", request.variantId.toString());
        tag.m_128405_("count", request.count);
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (this.examples == null) {
            this.examples = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterial(this.variantId));
        }
        return this.examples;
    }

    public RepairKit copyWithCount(int newCount) {
        return new RepairKit(this.variantId, newCount);
    }

    public int getCount() {
        return this.count;
    }

    public int getMinimumCount() {
        return 1;
    }

    public boolean matches(@NotNull ItemStack stack) {
        return RepairKit.isRepairKitItem(stack, this.variantId);
    }

    public static boolean isRepairKitItem(ItemStack stack, MaterialVariantId variantId) {
        IRepairKitItem item;
        Item item2 = stack.m_41720_();
        return item2 instanceof IRepairKitItem && (item = (IRepairKitItem)item2).getMaterial(stack).matchesVariant(variantId);
    }

    public MaterialVariantId getVariantId() {
        return this.variantId;
    }
}

