/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.minecolonies.api.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_compatibility.module.common.storagedrawers.init.ModuleBlockEntities;
import steve_gall.minecolonies_compatibility.module.common.storagedrawers.init.ModuleItems;

public class CitizenSlaveTile
extends BlockEntitySlave
implements INetworkStorageViewHolder,
IAccessDirectionHolder {
    private final StorageView view;
    private final ItemStackCounter counter;
    private AccessDirection accessDirection = AccessDirection.INSERT_EXTRACT;

    public CitizenSlaveTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModuleBlockEntities.CITIZEN_SLAVE.get(), pos, state);
        this.view = new StorageView();
        this.counter = new ItemStackCounter();
        this.counter.addListener(this::onCounterChanged);
    }

    public void readPortable(CompoundTag compound) {
        super.readPortable(compound);
        this.view.readLink(compound.m_128469_("view"));
        this.accessDirection = AccessDirection.deserialize(compound.m_128423_("accessDirection"));
    }

    public CompoundTag writePortable(CompoundTag compound) {
        compound = super.writePortable(compound);
        compound.m_128365_("view", (Tag)this.view.writeLink());
        compound.m_128365_("accessDirection", this.accessDirection.serialize());
        return compound;
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    @Override
    @NotNull
    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }

    @Override
    public void setAccessDirection(@NotNull AccessDirection value) {
        if (this.accessDirection != value) {
            this.accessDirection = value;
            this.view.requestAll();
            this.m_6596_();
        }
    }

    public void m_6596_() {
        Level level = this.m_58904_();
        if (level != null) {
            WorldUtil.markChunkDirty((Level)level, (BlockPos)this.m_58899_());
        }
        super.m_6596_();
    }

    public void update() {
        Iterable<Object2LongMap.Entry<ItemStackKey>> stacks = this.getStacks();
        this.counter.replace(stacks);
    }

    private void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            this.view.enqueue(key.getStack(newCount));
        }
    }

    private Iterable<Object2LongMap.Entry<ItemStackKey>> getStacks() {
        BlockEntityController controller = this.getController();
        if (controller == null) {
            return Collections.emptyList();
        }
        ItemStackCounter counter = new ItemStackCounter();
        NonNullList allItems = controller.getItemRepository().getAllItems();
        for (IItemRepository.ItemRecord stack : allItems) {
            if (stack == null || stack.itemPrototype.m_41619_() || stack.count <= 0) continue;
            ItemStackKey key = new ItemStackKey(stack.itemPrototype);
            counter.insert(key, stack.count);
        }
        return counter.entrySet();
    }

    public static <BLOCK_ENTITY extends CitizenSlaveTile> void tick(Level level, BlockPos pos, BlockState state, BLOCK_ENTITY blockEntity) {
        blockEntity.onTick();
    }

    protected void onTick() {
        Level level = this.m_58904_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46467_() % 100L == 0L) {
            this.update();
        }
        this.view.onTick();
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenSlaveTile.this.f_58857_;
        }

        @Override
        public BlockPos getPos() {
            return CitizenSlaveTile.this.f_58858_;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)ModuleItems.CITIZEN_SLAVE.get());
        }

        @Override
        public boolean isActive() {
            return CitizenSlaveTile.this.getController() != null;
        }

        @Override
        public boolean canExtract() {
            return CitizenSlaveTile.this.getAccessDirection().canExtract();
        }

        @Override
        public boolean canInsert() {
            return CitizenSlaveTile.this.getAccessDirection().canInsert();
        }

        @Override
        @NotNull
        public Stream<ItemStack> getAllStacks() {
            return CitizenSlaveTile.this.counter.entrySet().stream().map(e -> ((ItemStackKey)e.getKey()).getStack(e.getLongValue()));
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CitizenSlaveTile.this.m_6596_();
        }

        @Override
        public void unlink() {
            super.unlink();
            CitizenSlaveTile.this.m_6596_();
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, boolean simulate) {
            BlockEntityController controller = CitizenSlaveTile.this.getController();
            if (controller == null) {
                return ItemStack.f_41583_;
            }
            return controller.getItemRepository().extractItem(stack, stack.m_41613_(), simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            BlockEntityController controller = CitizenSlaveTile.this.getController();
            if (controller == null) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate);
        }
    }
}

