/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.ISecondaryRollableRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.PlatingGenericRecipe;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class PlatingRecipeStorage
extends GenericedRecipeStorage<PlatingGenericRecipe>
implements ISecondaryRollableRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_plating");
    private final Block block;
    private final List<ItemStorage> ingredients;
    private final ItemStack container;
    private final ItemStack output;
    private final PlatingGenericRecipe recipe;

    public static void serialize(IFactoryController controller, CompoundTag tag, PlatingRecipeStorage recipe) {
        tag.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)recipe.block).toString());
    }

    public static PlatingRecipeStorage deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation blockId = new ResourceLocation(tag.m_128461_("block"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        return new PlatingRecipeStorage(block);
    }

    private PlatingRecipeStorage(Block block) {
        this.block = block;
        ArrayList<ItemStorage> ingredients = new ArrayList<ItemStorage>();
        ItemStack container = ItemStack.f_41583_;
        ItemStack output = ItemStack.f_41583_;
        if (block instanceof FeastBlock) {
            FeastBlock feastBlock = (FeastBlock)block;
            BlockState state = feastBlock.m_49966_();
            int maxServings = feastBlock.getMaxServings();
            ingredients.add(new ItemStorage(new ItemStack((ItemLike)block)));
            for (int i = 0; i < maxServings; ++i) {
                state = (BlockState)state.m_61124_((Property)feastBlock.getServingsProperty(), (Comparable)Integer.valueOf(maxServings - i));
                ItemStack servingItem = feastBlock.getServingItem(state);
                if (!output.m_41619_() && !ItemStack.m_150942_((ItemStack)output, (ItemStack)servingItem)) {
                    output = ItemStack.f_41583_;
                    container = ItemStack.f_41583_;
                    break;
                }
                if (output.m_41619_()) {
                    output = servingItem.m_41777_();
                } else {
                    output.m_41764_(output.m_41613_() + servingItem.m_41613_());
                }
                if (!servingItem.hasCraftingRemainingItem()) continue;
                ItemStack containerItem = servingItem.getCraftingRemainingItem();
                if (!container.m_41619_() && !ItemStack.m_150942_((ItemStack)container, (ItemStack)containerItem)) {
                    output = ItemStack.f_41583_;
                    container = ItemStack.f_41583_;
                    break;
                }
                if (container.m_41619_()) {
                    container = containerItem.m_41777_();
                    continue;
                }
                container.m_41764_(container.m_41613_() + containerItem.m_41613_());
            }
        }
        if (!container.m_41619_()) {
            ingredients.add(new ItemStorage(container.m_255036_(1), container.m_41613_()));
        }
        this.ingredients = ingredients;
        this.container = container;
        this.output = output;
        this.recipe = new PlatingGenericRecipe(this);
    }

    public PlatingRecipeStorage(FeastBlock block) {
        this((Block)block);
    }

    @Override
    @NotNull
    public List<ItemStack> rollSecondaryOutputs(@NotNull LootParams context) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Block block = this.block;
        if (block instanceof FeastBlock) {
            FeastBlock feastBlock = (FeastBlock)block;
            BlockState state = (BlockState)feastBlock.m_49966_().m_61124_((Property)feastBlock.getServingsProperty(), (Comparable)Integer.valueOf(0));
            return Block.m_49869_((BlockState)state, (ServerLevel)context.m_287182_(), (BlockPos)BlockPos.f_121853_, null);
        }
        return list;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PlatingRecipeStorage) {
            PlatingRecipeStorage other = (PlatingRecipeStorage)o;
            return this.block == other.block;
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public Block getBlock() {
        return this.block;
    }

    public List<ItemStorage> getInput() {
        return this.ingredients;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @Override
    public PlatingGenericRecipe getGenericRecipe() {
        return this.recipe;
    }
}

