/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.atmospheric;

import com.teamabnormals.atmospheric.common.block.AloeVeraBlock;
import com.teamabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class AloeVeraTallFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AtmosphericBlocks.TALL_ALOE_VERA.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericBlocks.ALOE_VERA.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get()), new ItemStack((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get()), new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return state.m_60734_() == AtmosphericBlocks.TALL_ALOE_VERA.get() && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)AloeVeraTallBlock.AGE) == 8;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get(), (Integer)state.m_61143_((Property)AloeVeraTallBlock.AGE) - 5));
            drops.add(new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get()));
            drops.add(new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get(), 3 + level.f_46441_.m_188503_(5)));
            level.m_7731_(context.getPosition(), (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).m_49966_().m_61124_((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(2)), 18);
            level.m_7731_(context.getPosition().m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            return drops;
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.f_12344_;
    }
}

